package com.xiaomai.cases.polar.memberCard;

import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.polar.finance.order.OrderTools;
import com.xiaomai.cases.polar.member.Tools;
import com.xiaomai.cases.polar.training.TrainingTools;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.annotations.BeforeClass;

import javax.annotation.Resource;
import java.math.BigDecimal;

/**
 * @author adu
 * data 2024/7/24 10:15
 */

public class GetMemberCardBaseInfoForSign extends BaseTestImpl {

    String memberId = "";
    String memberCardId="";
    @Resource(name = "tools")
    Tools tools;
    @Resource(name = "orderTools")
    OrderTools orderTools;

    @Resource(name = "trainingTools")
    TrainingTools trainingTools;
    @Resource(name = "cardTools")
    CardTools cardTools;
    String shelfState="";
    BigDecimal quantity; //可用次数
    float price; //价格
    int validPeriod; //有效期
    String latestSnapshotId;//最近的快照ID


    @BeforeClass
    @Override
    public void beforeTest() {
        super.beforeTest();
        //搜索目标会员
        String phone = "17682302508";
        memberId = trainingTools.searchTargerMember(phone);
        if (memberId.isEmpty()) {
            memberId = tools.create("测试机吴彦祖", phone).getString("result");
        }

        //搜索目标会员卡-次卡
        String title = "嘟嘟创建的会员卡-次卡";
        cardTools.doMemberCardcommonSearch(title,"MEMBER_CARD");
        int total = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result").size();
        if (total > 0) {
            memberCardId = XMJSONPath.readPath(dataApi.getApi_response(), "$.result[0].id");
            shelfState = XMJSONPath.readPath(dataApi.getApi_response(), "$.result[0].shelfState");//YES,上架状态：YES
            if (shelfState.equals("NO")) {
                cardTools.modifyMemberCardShelfState(memberCardId, "YES");
            }
        } else {
            //创建一个新的会员卡
            memberCardId = cardTools.oneKeyCreateMembershipCardNumberCard(title);
        }

        //获取会员卡详情
        cardTools.fetchDetailById(memberCardId);
        quantity= new BigDecimal(XMJSONPath.readPath(dataApi.getApi_response(),"$.result.benefitList[0].balance"));
        price=Float.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.price"));
        validPeriod=Integer.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.validPeriod"));
        latestSnapshotId=XMJSONPath.readPath(dataApi.getApi_response(), "$.result.latestSnapshotId");

        //给会员签单-购买会员卡
        orderTools.signOrder(memberCardId,latestSnapshotId,quantity,price,validPeriod,
                latestSnapshotId,0,"FIRST_USED","MEMBER_CARD",
                memberId,price,price,"1",true);

    }

}

    