package com.xiaomai.cases.polar.training;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.util.ArrayList;

/**
 * 编辑训练营活动
 * 场景1：未发布的操作编辑
 * 场景2：报名中的操作编辑
 *
 * @author adu
 * data 2024/7/3 20:51
 */

public class TestEditTraining extends BaseCreateTrainingData {
    @Resource(name = "trainingTools")
    TrainingTools trainingTools;
    String trainingId = "";
    String oneKeytTrainingId = "";

    @BeforeClass
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Training, "API_editTraining", LoginAccount.ADU_PROD, Terminal.B, "adu");
        super.beforeTest();
    }

    @Test(description = "测试编辑未发布的训练营活动")
    public void testEditTraining() {
        //1创建未发布的训练营活动
        String title = "杭州减肥训练营-未发布" + RandomStringUtil.randomString(3);
        trainingId = trainingTools.createTrainingNoPublish(title, courseId, trainerListIdS);
        //根据训练营活动名称全局搜索
        trainingTools.commonSearchTraining(title);
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result").size() > 0, "刚创建的活动没在全局搜索中发现哈");
        //编辑未发布的活动
        JSONObject body = new JSONObject();
        body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
        body.put("studioId", xmAppApi.getLoginInfo().getStudioId()); // 场馆
        body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        body.put("applyEndTime", applyEndTime);//报名结束时间
        body.put("applyStartTime", applyStartTime);//报名开始时间
        body.put("courseId", courseId); //关联课程ID
        body.put("creatorId", xmAppApi.getLoginInfo().getAdminId()); // 创建人即操作者
        body.put("openEndDate", openEndDate1); //改了开营开始时间
        body.put("openStartDate", openStartDate1); //改了开营结束时间
        body.put("price", 0.09); //售卖价格
        body.put("surfaceUrl", "https://xiaomai-res.oss-cn-hangzhou.aliyuncs.com/xmfit/course_cover/training_camp_0.png"); // 默认活动封面图
        String editTitle = "杭州自动化测试训练营-未发布-编辑title" + RandomStringUtil.randomString(3);
        body.put("title", editTitle);
        body.put("totalClassHour", 1); // 总课次数
        body.put("traineeLowerLimit", 1); // 开营人数
        body.put("traineeUpperLimit", 10); // 人数上限
        body.put("trainerList", editTrainerListId); // 移除一个人
        body.put("xcxSaleStatus", "NO"); //开启改成关闭小程序售卖
        body.put("underlinePrice", 999); //划线价
        body.put("id", trainingId); //活动ID
        xmAppApi.doRequest(RequestType.JSON, params, body.toString(), headers).assetsSuccess(true);

        //查看训练营活动详情
        trainingTools.findTrainingDetailById(trainingId);
        String detailResult = dataApi.getApi_response();
        Assert.assertEquals(XMJSONPath.readPath(detailResult, "$.result.title"), editTitle);
        Assert.assertEquals(XMJSONPath.readPath(detailResult, "$.result.openStartDate"), openStartDate1);
        Assert.assertEquals(XMJSONPath.readPath(detailResult, "$.result.xcxSaleStatus"), "NO");
        Assert.assertEquals(Double.valueOf(XMJSONPath.readPath(detailResult, "$.result.underlinePrice")), 999.00);
        Assert.assertEquals(Double.valueOf(XMJSONPath.readPath(detailResult, "$.result.price")), 0.09);
        Assert.assertEquals(XMJSONPath.readPath(detailResult, "$.result.traineeLowerLimit"), "1");
        Assert.assertEquals(XMJSONPath.readPath(detailResult, "$.result.traineeUpperLimit"), "10");
        Assert.assertEquals(XMJSONPath.readPath(detailResult, "$.result.totalClassHour"), "1");
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(detailResult, "$.result.trainerIds").size() == 1, "教练修改成1个人后，数据对不上");

    }

    @Test(description = "编辑已发布训练营活动")
    public void editPublishTraining() {
        //1.查询关联对应课程的活动数据
        trainingTools.searchTrainingList(courseId, new ArrayList<>());
        int listCountBefore = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.records").size();
        //2.创建已发布的训练营活动
        oneKeytTrainingId = trainingTools.oneKeyCreateTraining(courseId, trainerListIdS);
        //3.列表搜索数据check
        trainingTools.searchTrainingList(courseId, new ArrayList<>());
        int listCountAfter = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.records").size();
        Assert.assertEquals(listCountAfter, (listCountBefore + 1), "训练营活动创建成功列表数据没增加");
        JSONObject goalObject = XMJSONPath.getJSONObjectByReadPath(dataApi.getApi_response(), "$.result.records[0]");
        String title=goalObject.getString("title");
        String applyEndTime=goalObject.getString("applyEndTime");
        String applyStartTime=goalObject.getString("applyStartTime");
        String openStartDate=goalObject.getString("openStartDate");
        String openEndDate=goalObject.getString("openEndDate");
        //4.编辑已发布的活动（训练营名称，关联课程，开营时间，总课次数，售价，报名开始时间，报名结束时间不能修改）check不能修改的传值后也不会改变
        JSONObject editBody = new JSONObject();
        editBody.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
        editBody.put("studioId", xmAppApi.getLoginInfo().getStudioId()); // 场馆
        editBody.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        editBody.put("applyEndTime", applyEndTime);//报名结束时间
        editBody.put("applyStartTime", applyStartTime);//报名开始时间
        editBody.put("courseId", courseId); //关联课程ID
        editBody.put("creatorId", xmAppApi.getLoginInfo().getAdminId()); // 创建人即操作者
        editBody.put("openEndDate", openEndDate); //开营结束时间
        editBody.put("openStartDate", openStartDate); //开营开始时间
        editBody.put("price", 10); //售卖价格
        editBody.put("surfaceUrl", "https://xiaomai-res.oss-cn-hangzhou.aliyuncs.com/xmfit/course_cover/training_camp_0.png"); // 默认活动封面图
        editBody.put("title","title" );//名称不能修改，这里故意修改了，等保存后check数据
        editBody.put("totalClassHour", 20); // 总课时数，不能修改，这里故意修改了，等保存后check数据
        editBody.put("traineeLowerLimit", 1); // 开营人数
        editBody.put("traineeUpperLimit", 99); // 人数上限
        editBody.put("trainerList", trainerListIdS); // 上课教练
        editBody.put("xcxSaleStatus", "YES"); //开启小程序售卖
        editBody.put("underlinePrice", 29.9);//可以修改
        editBody.put("id",oneKeytTrainingId); //活动ID
        xmAppApi.doRequest(RequestType.JSON, params, editBody.toString(), headers).assetsSuccess(true);
        //5.查看活动详情，check 不能修改项和一修改项是否被同步修改
        trainingTools.findTrainingDetailById(oneKeytTrainingId);
        //5.1不能修改的字段check（修改后和修改前比对）
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(),"$.result.title"),title);
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(),"$.result.totalClassHour"),"2");
        Assert.assertEquals(Double.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.price")), 0.00);
        //5.2可以修改字段check是否被同步修改
        Assert.assertEquals(Double.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.underlinePrice")), 29.90);

    }


    @AfterClass(description = "删除此case创建的训练营")
    public void delData() {
        if (!trainingId.isEmpty()) {
            trainingTools.deleteTraining(trainingId);
        }
        if (!oneKeytTrainingId.isEmpty()) {
            trainingTools.deleteTraining(oneKeytTrainingId);
        }

    }

}

