package com.xiaomai.cases.polar.data.financeData;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;

public class FinanceDataTools extends XMBaseTest {

    /**
     * @param
     * @description:获取数据中心-财务数据-订单数据-汇总
     * @param dateType：时间类型：[ DAY, WEEK, MONTH, QUARTER, YEAR ]
     * @param startTime：开始时间
     * @param endTime:结束时间  注意：使用这个方法只能搜按天和按月，因为参数类型这里写的long 其他几个不是long型，会用不了
     * @author: yangfangfang
     **/
    public JSONObject getOrderData(String dateType,long startTime, long endTime,  DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Data)
                .setApiName("API_getOrderData")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject getOrderData=new JSONObject();
        getOrderData.put("dateType",dateType);
        getOrderData.put("endTime",endTime );
        getOrderData.put("startTime",startTime);
        getOrderData.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        getOrderData.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        getOrderData.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, getOrderData.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }


    /**
     * @param
     * @description:获取数据中心-财务数据-订单趋势图
     * @param dateType：时间类型：[ DAY, WEEK, MONTH, QUARTER, YEAR ]
     * @param metric：[ "订单应收金额", "订单实收金额", "欠费金额", "实退金额" ]指标[ ORDER_RECEIVABLE_AMOUNT, ORDER_ACTUAL_AMOUNT, ORDER_UNPAID_AMOUNT, ORDER_REFUND_AMOUNT ]
     * @param startTime：开始时间
     * @param endTime:结束时间  注意：使用这个方法只能搜按天和按月，因为参数类型这里写的long 其他几个不是long型，会用不了
     * @author: yangfangfang
     **/
    public JSONObject getOrderTrend(String dateType,String metric,long endTime,long startTime, DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Data)
                .setApiName("API_getOrderTrend")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject trend=new JSONObject();
        trend.put("dateType",dateType);
        trend.put("endTime", endTime);
        trend.put("startTime", startTime);
        trend.put("metric",metric);
        trend.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        trend.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        trend.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, trend.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:获取数据中心-财务数据-订单明细
     * @param dateType：时间类型：[ DAY, WEEK, MONTH, QUARTER, YEAR ]
     * @param startTime：开始时间
     * @param endTime:结束时间  注意：使用这个方法只能搜按天和按月，因为参数类型这里写的long 其他几个不是long型，会用不了
     * @param endTime:	string
     * @param sort :List [ "订单应收金额正序", "订单应收金额倒序", "订单实收金额正序", "订单实收金额倒序", "欠费金额正序", "欠费金额倒序", "退款金额正序", "退款金额倒序" ][ ORDER_RECEIVABLE_AMOUNT_ASC, ORDER_RECEIVABLE_AMOUNT_DESC, ORDER_ACTUAL_AMOUNT_ASC, ORDER_ACTUAL_AMOUNT_DESC, ORDER_UNPAID_AMOUNT_ASC, ORDER_UNPAID_AMOUNT_DESC, ORDER_REFUND_AMOUNT_ASC, ORDER_REFUND_AMOUNT_DESC ]
     * @author: yangfangfang
     **/
    public JSONObject getOrderDetail(String dateType,String sort,long startTime, long endTime,  DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Data)
                .setApiName("API_getOrderDetail")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject getOrderDetail=new JSONObject();
        getOrderDetail.put("dateType",dateType);
        getOrderDetail.put("endTime",endTime );
        getOrderDetail.put("startTime",startTime);
        getOrderDetail.put("sort",sort);
        getOrderDetail.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        getOrderDetail.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        getOrderDetail.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, getOrderDetail.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

}
