package com.xiaomai.cases.polar.admin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.polar.course.CourseTools;
import com.xiaomai.cases.polar.setting.courseCategory.CourseCategoryTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

import javax.annotation.Resource;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.admin
 * @Author: xuyamei
 * @CreateTime: 2024-07-01  16:57
 * @Description: 校验取消授课或者移除所授课程
 * @Version: 1.0
 */
public class TestCheckModifyTeaching extends BaseTestImpl {
    @Resource(name = "adminTools")
    AdminTools adminTools;
    @Resource(name = "courseTools")
    CourseTools courseTools;

    @Resource(name = "courseCategoryTools")
    CourseCategoryTools courseCategoryTools;
    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_Admin,"API_addStudioAdmin", LoginAccount.GYM_PROD, Terminal.B,"xym");
        super.beforeTest();
    }

    @DataProvider()
    public Object[][] data() {
        JSONArray coachTeachingTypes = new JSONArray();
        coachTeachingTypes.add("LEAGUE_CLASS");
        coachTeachingTypes.add("PERSONAL_TRAINERS");
        coachTeachingTypes.add("TRAINING_CAMP");

        return new Object[][]{
                {false,coachTeachingTypes},
                {true,coachTeachingTypes}

        };
    }
    @Test(description = "测试修改老师授课状态",dataProvider = "data")
    public void testCheckModifyTeaching(boolean teaching,JSONArray coachTeachingTypes) {
        // 查询存量的课程分类
        String categoryId = courseCategoryTools.getCourseCategoryPage("瑜伽");
        // 查询私教课
        courseTools.getPersonalOrGroupCourseId("PERSONAL","瑜伽",categoryId,"STUDIO","ONE_TO_MANY",2,1);
        // 课程类型

        if (teaching){
            coachTeachingTypes.remove("PERSONAL_TRAINERS");

        }

        JSONObject response = adminTools.checkModifyTeaching(xmAppApi.getLoginInfo().getAdminId(),teaching,coachTeachingTypes);
        Assert.assertTrue(response.getJSONArray("disables").size()>0,"修改是否授课或者还有其他关联业务关联不能移除 返回的结果是空");

    }

}
