package com.xiaomai.cases.polar.data;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestTetCourseCostData extends XMBaseTest {
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Data)
                .setApiName("API_getCourseCostData")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("yj")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @Test(description = "上课数据-课消数据-全部")
    public void testgetCourseCostData() {



        JSONObject jsonObject = new JSONObject();
        jsonObject.put("dateType","WEEK");
        jsonObject.put("endTime", TimeUtils.getWeekLastTime());
        jsonObject.put("startTime",TimeUtils.getWeekFirstTime());
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());



        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);

    }
    @Test(description = "上课数据-课消数据-团课")
    public void testgetCourseCostData1() {



        JSONObject jsonObject = new JSONObject();
        jsonObject.put("dateType","WEEK");
        jsonObject.put("consumeType","GROUP_CLASS");
        jsonObject.put("endTime", TimeUtils.getWeekLastTime());
        jsonObject.put("startTime",TimeUtils.getWeekFirstTime());
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());



        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);

    }
    @Test(description = "上课数据-课消数据-私教课")
    public void testgetCourseCostData2() {



        JSONObject jsonObject = new JSONObject();
        jsonObject.put("dateType","WEEK");
        jsonObject.put("consumeType","PERSONAL");
        jsonObject.put("endTime", TimeUtils.getWeekLastTime());
        jsonObject.put("startTime",TimeUtils.getWeekFirstTime());
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());



        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);

    }
    @Test(description = "上课数据-课消数据-训练营")
    public void testgetCourseCostData3() {



        JSONObject jsonObject = new JSONObject();
        jsonObject.put("dateType","WEEK");
        jsonObject.put("consumeType","TRAINING_CAMP");
        jsonObject.put("endTime", TimeUtils.getWeekLastTime());
        jsonObject.put("startTime",TimeUtils.getWeekFirstTime());
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());



        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);

    }
    @Test(description = "上课数据-课消数据-手动扣次")
    public void testgetCourseCostData4() {



        JSONObject jsonObject = new JSONObject();
        jsonObject.put("dateType","WEEK");
        jsonObject.put("consumeType","MANUAL_DEDUCT");
        jsonObject.put("endTime", TimeUtils.getWeekLastTime());
        jsonObject.put("startTime",TimeUtils.getWeekFirstTime());
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());



        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);

    }
    @Test(description = "上课数据-课消数据-自动消耗")
    public void testgetCourseCostData5() {



        JSONObject jsonObject = new JSONObject();
        jsonObject.put("dateType","WEEK");
        jsonObject.put("consumeType","AUTO_CONSUME");
        jsonObject.put("endTime", TimeUtils.getWeekLastTime());
        jsonObject.put("startTime",TimeUtils.getWeekFirstTime());
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());



        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);

    }
    @Test(description = "上课数据-课消数据-单次约课")
    public void testgetCourseCostData6() {



        JSONObject jsonObject = new JSONObject();
        jsonObject.put("dateType","WEEK");
        jsonObject.put("consumeType","SINGLE_RESERVE");
        jsonObject.put("endTime", TimeUtils.getWeekLastTime());
        jsonObject.put("startTime",TimeUtils.getWeekFirstTime());
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());



        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);

    }
}
