package com.xiaomai.cases.polar.export;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

/**
 * @Author zxy
 * @Description
 * @Date 2024/11/15 15:47
 */
public class TestExportReserve extends XMBaseTest {
    ExportTool exportTool = new ExportTool();
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Export)
                .setApiName("API_exportReserve")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("zyx")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @DataProvider
    public Object[][] data(){
        return new Object[][]{
                {"GROUP_CLASS","导出团课预约记录"},
                {"PERSONAL","导出私教预约记录"},
                {"TRAINING_CAMP","导出训练营预约记录"}
        };
    }

    @Test(description = "预约记录导出",dataProvider = "data")
    public void testExportCard(String courseType,String workflowName){
        JSONObject object = new JSONObject();
        object.put("signInState","SIGNED");
        object.put("courseType",courseType);
        object.put("current",0);
        object.put("size",20);
        object.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        object.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        object.put("operatorId",xmAppApi.getLoginInfo().getAdminId());


        xmAppApi.doRequest(RequestType.JSON,params,object.toString(),headers).assetsSuccess(true);

        try {
            Thread.sleep(3000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        JSONObject res = exportTool.pageStudioExportRecord().getJSONObject("result").getJSONArray("records").getJSONObject(0);
        Assert.assertEquals(res.getString("id"),xmAppApi.getBodyInJSON().getString("result"));
        Assert.assertEquals(res.getString("workflowName"),workflowName);
        Assert.assertEquals(res.getString("state"),"SUCCESS");

        //下载文件
        if(res.getString("state").equals("SUCCESS")){
            exportTool.getUrl(res.getJSONObject("json").getString("resourceId"));
        }
    }
}
