package com.xiaomai.cases.polar.memberCard;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.clue.MemberTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestMemberCardSearch extends XMBaseTest {
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_commonSearch")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("yj")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @Test(description = "会员卡列表搜索")
    public void testMemberCardcommonSearch() {
        CardTools Cardtools = new CardTools();
        Cardtools.memberCardCreate("次卡-自动化会员卡"+ RandomStringUtil.randomString(3));//创建随机的名的次卡
        Cardtools.fetchPageOfMemberCard();

        String title = XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].title");



        JSONObject jsonObject = new JSONObject();
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("title",title);//这里需要搜索新创建的会员卡
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());



        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);

    }
}
