package com.xiaomai.cases.polar.admin;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.polar.studioConfig.ConfigTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import javax.swing.*;
import java.util.Random;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.admin
 * @Author: xuyamei
 * @CreateTime: 2024-02-29  11:48
 * @Description: 新建角色
 * @Version: 1.0
 */
public class TestAddStudioAdmin extends BaseTestImpl {
    @Resource(name = "adminTools")
    AdminTools adminTools;

    @Resource(name = "configTools")
    ConfigTools configTools;

    @BeforeClass
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_Admin,"API_addStudioAdmin", LoginAccount.XYM_DEV, Terminal.B,"xym");
        super.beforeTest();
    }

    @Test(description = "添加员工，由于没有删除员工的操作，则每次随机取一个角色")
    public void testAddStudioAdmin(){
        String[] role = {"店长","教练","销售主管","财务","前台"};
        Random rand = new Random();
        JSONObject addRequest = adminTools.addStudioAdmin(role[rand.nextInt(5)]);
        // 添加角色成功后
        String result = dataApi.getBodyInJSON().getString("result");
        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        // 查询员工详情内容
        JSONObject adminInfo = adminTools.getStudioAdmin(result);
        String[] resultString = {"name","phone","roles","teaching"};  // 新建之后验证相应的值
        for (int i = 0; i < resultString.length; i++){
            // check 1:创建员工时的值与查询员工详情时的值是否一致
            Assert.assertEquals(addRequest.getString(resultString[i]),adminInfo.getJSONObject("result").getString(resultString[i]),"添加员工失败,员工详情与创建员工时的信息不一致");
        }
        // check 2: 生成对应的操作日志
        String body = "{\"current\":0,\"size\":10,\"domainId\":\""+xmAppApi.getLoginInfo().getStudioId()+"\",\"opEventKey\":\"ADD_ADMIN\"}";
        JSONObject response = configTools.getOpauditPage(body);
        Assert.assertEquals(response.getJSONObject("result").getJSONArray("records").getJSONObject(0).getJSONObject("target").getString("targetId"),result,"添加员工未生成操作日志");

    }
}
