package com.xiaomai.cases.polar.member;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @Author zxy
 * @Description
 * @Date 2024/3/14 17:08
 */
public class TestGetDetailById extends XMBaseTest {
    MemberTools memberTools = new MemberTools();

    @BeforeMethod
    public void beforeTest(){

        xmAppApi.setApiModule(ApiModule.Polar_Member)
                .setApiName("API_findDetailById")
                .setLoginUser(LoginAccount.ZYX_DEV)
                .setTerminal(Terminal.B);

        dal.setCase_owner("zyx")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @Test(description = "会员详情")
    public void testGetDetailById() {
        String name = "自动化潜在会员" + RandomStringUtil.randomString(3);
        String phone = RandomStringUtil.randomMobile("666");

        String id = memberTools.create(name, phone).getString("result");

        JSONObject object = new JSONObject();
        object.put("memberId",id);

        xmAppApi.doRequest(RequestType.JSON,params,object.toString(),headers).assetsSuccess(true);
        JSONObject res = xmAppApi.getBodyInJSON();

        Assert.assertEquals(res.getJSONObject("result").getString("phone"),phone);

    }

    @Test(description = "会员详情-id为空")
    public void testGetDetailById_1() {

        JSONObject object = new JSONObject();
        object.put("memberId","");

        xmAppApi.doRequest(RequestType.JSON,params,object.toString(),headers).assetsSuccess(false);
        Assert.assertEquals(XMJSONPath.readPath(xmAppApi.getBodyInJSON(), "$.message"), "会员id不能为空");

    }
}
