package com.xiaomai.cases.polar.setting.tag;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.setting.TagTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestCreate extends XMBaseTest {


    String tagId1;
    String tagId2;

    TagTools tagTools=new TagTools();

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_tag_create")
                .setLoginUser(LoginAccount.YFF_DEV)
                .setTerminal(Terminal.B);
        dal.setCase_owner("yff")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }


    @Test(description = "添加标签-成功")
    public void testCreate(){

        //获取当前标签列表
        JSONObject fetchPage=tagTools.tagFetchPage("");
        int total= Integer.parseInt(fetchPage.getJSONObject("result").getString("total"));

        //添加标签
        JSONObject jsonObject=new JSONObject();
        jsonObject.put("bizAccountId",xmAppApi.getLoginInfo().getAdminId());
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("label","自动化"+ RandomStringUtil.randomString(3));

        xmAppApi.doRequest(RequestType.JSON,params,jsonObject.toJSONString(),headers).assetsSuccess(true);
        JSONObject response=xmAppApi.getBodyInJSON();
        tagId1=response.getString("result");
        String success=response.getString("success");
        Assert.assertEquals(success,"true","添加标签失败");

        JSONObject fetchPage2=tagTools.tagFetchPage("");
        int total2= Integer.parseInt(fetchPage2.getJSONObject("result").getString("total"));
        boolean flag=false;
        if(total2==(total+1)){
            flag=true;
        }
        Assert.assertEquals(flag,true,"添加标签失败");


        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }

    }

    @Test(description = "添加相同名称标签-失败")
    public void testCreateSameName(){

        //添加第一个标签
        JSONObject createTag=tagTools.tagCreate("自动化-禁止使用");
        tagId2=createTag.getString("result");

        //添加第二个标签名称与第一个相同
        JSONObject jsonObject=new JSONObject();
        jsonObject.put("bizAccountId",xmAppApi.getLoginInfo().getAdminId());
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("label","自动化-禁止使用");

        xmAppApi.doRequest(RequestType.JSON,params,jsonObject.toJSONString(),headers).assetsSuccess(false);
        JSONObject response=xmAppApi.getBodyInJSON();
        String code=response.getString("code");
        String success=response.getString("success");
        Assert.assertEquals(success,"false","相同标签不能添加，但可添加");
        Assert.assertEquals(code,"error/.TAG_NAME_DUPLICATE","同标签名已存在，不可重复");

    }


    @Test(description = "删除标签",priority = 1)
    public void deleteTag(){
        tagTools.tagDelete(tagId1);
        tagTools.tagDelete(tagId2);
    }
}
