package com.xiaomai.cases.lunar.order;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.lunar.minmembercard.MinCardTools;
import com.xiaomai.cases.lunar.user.UserTools;
import com.xiaomai.cases.polar.finance.order.OrderTools;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestPurchaseCard extends BaseTestImpl {

    String memberId;

    String cardId;

    MinCardTools minCardTools=new MinCardTools();

    UserTools userTools=new UserTools();

    OrderCTools orderCTools=new OrderCTools();

    OrderTools orderTools=new OrderTools();



    @BeforeClass
    public void beforeTest(){
        setTestInfo(ApiModule.Lunar_Order,"API_purchaseCard", LoginAccount.GYM_MINIAPPC, Terminal.minApp,"yff");
        super.beforeTest();
    }

    @Test(description = "C端购买订单")
    public void testPurchaseCard(){


        //获取会员信息
        memberId = userTools.getMemberInfo().getString("memberId");

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        //获取会员卡
        cardId=minCardTools.fetchOnSaleMemberCard("C端0元会员卡自动化").getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("activatePattern","PURCHASE");
        jsonObject.put("cardId",cardId);
        jsonObject.put("cardSnapshotId",cardId);
        jsonObject.put("memberId",memberId);
        jsonObject.put("memo", RandomStringUtil.randomString(6));
        jsonObject.put("receivableAmount",0);
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("objectId", RandomStringUtil.randomString(16));

        xmAppApi.doRequest(RequestType.JSON,params,jsonObject.toString(),headers).assetsSuccess(true);
        JSONObject response=xmAppApi.getBodyInJSON();
        String success=response.getString("success");
        String signId=response.getString("result");//订单ID
        Assert.assertEquals(success,"true","C端创建0元签单失败");

        try {
            Thread.sleep(3000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }


        //校验C端订单详情

        JSONObject getDetail=orderCTools.getDetail(signId);
        String getDetailId=getDetail.getJSONObject("result").getString("id");
        String getDetailBusinessNo=getDetail.getJSONObject("result").getString("businessNo");
        String getDetailState=getDetail.getJSONObject("result").getString("state");
        String getDetailSource=getDetail.getJSONObject("result").getString("source");
        String getDetailSuccess=getDetail.getString("success");
        Assert.assertEquals(getDetailSuccess,"true","获取创建的签单订单详情失败");
        Assert.assertEquals(getDetailId.equals(signId),true,"获取签单订单详情和创建的签单订单ID不一致");
        Assert.assertEquals(getDetailState,"PAID","创建签单订单成功,但订单状态不是已完成");
        Assert.assertEquals(getDetailSource,"ONLINE_MALL","C端创建的签单订单,订单来源非会员创建");


        //校验C端订单列表

        JSONObject pageOrder=orderCTools.pageOrder(memberId);
        int pageOrderPages=Integer.parseInt(pageOrder.getJSONObject("result").getString("pages"));
        int pageOrderTotal=Integer.parseInt(pageOrder.getJSONObject("result").getString("total"));


        for(int k=0; k == pageOrderPages+1; k++){
            int n =k==pageOrderPages ? (pageOrderTotal%10==0 ? 10 : pageOrderTotal%10) : 10;
            JSONArray records=pageOrder.getJSONObject("result").getJSONArray("records");
            boolean flag=true;
            for(int i=0; i<n; i++){
                String pageOrderId=records.getJSONObject(i).getString("id");
                if(pageOrderId.equals(signId)){
                    flag = true;
                    break;
                }
            }
            Assert.assertEquals(true,flag,"在订单列表中未查询到创建的签单订单");
        }


        try {
            Thread.sleep(3000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        //切换B端校验

        DataUserInfo dataUserInfo = new DataUserInfo();
        dataUserInfo.setTerminal(Terminal.B);
        dataUserInfo.setLoginUser(LoginAccount.GYM_PROD);

        try {
            Thread.sleep(3000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        //获取B端订单管理列表
        JSONObject pageVoucherResult=orderTools.pageVoucher1(xmAppApi.getLoginInfo().getStudioId(),getDetailBusinessNo,dataUserInfo);
        int total=Integer.parseInt(pageVoucherResult.getJSONObject("result").getString("total"));
        Assert.assertEquals(total>=1,true,"订单管理列表获取创建的签单订单失败");

        //获取B端订单详情
        JSONObject getDetailBResult=orderTools.getDetail(signId);
        String getDetailBId = getDetailBResult.getJSONObject("result").getString("id");
        String getDetailBBusinessNo = getDetailBResult.getJSONObject("result").getString("businessNo");
        String getDetailBSource=getDetailBResult.getJSONObject("result").getString("source");
        Assert.assertEquals(getDetailBId.equals(signId),true,"C端创建的签单订单在B端和C端展示的订单id不一致");
        Assert.assertEquals(getDetailBBusinessNo.equals(getDetailBusinessNo),true,"C端创建的签单订单在B端和C端展示的订单号不一致");
        Assert.assertEquals(getDetailBSource,"ONLINE_MALL","C端创建的签单订单,B端展示订单来源非会员创建");





    }



}
