package com.xiaomai.cases.polar.setting.venue;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.lunar.user.UserTools;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;

public class TestScanCheckIn extends XMBaseTest {
    @Resource(name = "venueAreaTools")
    VenueAreaTools venueAreaTools;
    @Resource(name = "userTools")
    UserTools userTools;
    DataUserInfo info = new DataUserInfo();

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_scanCheckIn")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("xyy")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();

    }
    @Test(description = "b端场地预约扫入场码")
    public void testScanCheckIn() {

        JSONObject object = new JSONObject();
        object.put("identifier","11");
        object.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
        object.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        object.put("brandId",xmAppApi.getLoginInfo().getBrandId());

        //调用请求
        xmAppApi.doRequest(RequestType.JSON,params,object.toJSONString(),headers);
        Assert.assertEquals(XMJSONPath.readPath(xmAppApi.getBodyInJSON(),"$.message"),"订场记录不存在");
    }

    @Test(description = "小程序预约0元子场地1和子场地2-->b端手动签到-->b端扫码签到")
    public void testScanCheckIn_2() throws InterruptedException{
        //获取当前场地组数量
        int suiteNum = venueAreaTools.getVenueAreaSuiteList().getJSONArray("result").size();
        //1.创建场地
        String groupId = venueAreaTools.saveVenueArea();
        //检验可预约场地数大于0
        Assert.assertTrue(venueAreaTools.getEnableVenueAreas().getJSONArray("result").size()>0);
        //2.创建场地组名
        String suiteName = "西湖场地组" + RandomStringUtil.randomString(5);
        //检验该场地组名称是否重名，未重名则创建场地组
        boolean flag = venueAreaTools.checkExistsName(suiteName);
        if(flag==false){
            String suiteId = venueAreaTools.createOrEditVenueAreaSuite(null,suiteName);
            //场地组创建成功后，检验场地组列表数量+1
            Assert.assertTrue(venueAreaTools.getVenueAreaSuiteList().getJSONArray("result").size()==suiteNum+1);
            //检验场地组详情为启用中
            Assert.assertEquals(XMJSONPath.readPath(venueAreaTools.getVenueAreaSuiteById(suiteId),"$.result.state"),"ON");
            //场地组绑定场地数量
            int timeList = venueAreaTools.getSuiteVenueAreaTimeList(suiteId).getJSONArray("result").size();
            //4.场地组绑定场地
            venueAreaTools.bindVenueAreas(suiteId, groupId);
            Assert.assertTrue(venueAreaTools.getSuiteVenueAreaTimeList(suiteId).getJSONArray("result").size()==timeList+1);
            //获取子场地-1的areaId,一般子场的areaId为groupId+2；
            String areaId = String.valueOf(Long.valueOf(groupId)+2);
            //获取子场地-2的areaId,一般子场的areaId为groupId+3；
            String areaId2 = String.valueOf(Long.valueOf(groupId)+3);
            //获取场地预约规则设置-常规则预约规则数量
            int groupTime = venueAreaTools.getVenueAreaGroupTime(groupId).getJSONObject("result").getJSONArray("normalTimeVOS").size();
            //并且检验该场地组有可预约的时间
            Assert.assertTrue(venueAreaTools.getVenueAreaSuiteTimePeriods(suiteId).getJSONArray("result").size()>0);
            //5.批量创建可预约时间
            venueAreaTools.createBatchNormalDate(suiteId,groupId,"0.00");//全场价格设置为0元
            Thread.sleep(3000);
            //常规预约规则数+1
            Assert.assertTrue(venueAreaTools.getVenueAreaGroupTime(groupId).getJSONObject("result").getJSONArray("normalTimeVOS").size()==groupTime+1);
            //获取当天的0点
            String reserveDay = String.valueOf(TimeUtils.getTodayTime());
            //获取当前场地预约记录列表的数量
            int bookingNum = Integer.parseInt(XMJSONPath.readPath(venueAreaTools.pageVenueBooking(),"$.result.total"));

            //切换C端
            info.setTerminal(Terminal.minApp);
            info.setLoginUser(LoginAccount.GYM_MINIAPPC);
            //获取用户
            String memberId = userTools.getMemberInfo(info).getString("memberId");
            //获取当前时间小时数值往后+1
            String startMinute = String.valueOf((TimeUtils.hourOfDay()+1)*60);
            String endMinute = String.valueOf((TimeUtils.hourOfDay()+1)*60+30);//结束时间与开始时间相差30分钟
            //首次预约子场地-1，场地不冲突
            Assert.assertEquals(XMJSONPath.readPath(venueAreaTools.checkMemberVenueBookingConflict(startMinute,endMinute,"0.00",groupId,memberId,reserveDay,areaId,info),"$.result.conflict"),"false");
            //预约子场地-1
            String voucherId = venueAreaTools.purchaseAreaTimes(startMinute,endMinute,suiteId,groupId,memberId,reserveDay,areaId,info);//场地预约的订单id
            Thread.sleep(3000);
            String venueBookingRecordId = XMJSONPath.readPath(venueAreaTools.getByVoucher(voucherId,info),"$.result.id");//场地预约的记录id
            venueAreaTools.getCheckInIdentifier(venueBookingRecordId,info);//检验入场码生效
            //预约详情的状态为已预约
            Assert.assertEquals(XMJSONPath.readPath(venueAreaTools.getVenueBookingRecordDetail(venueBookingRecordId,info),"$.result.state"),"RESERVED");
            Thread.sleep(3000);
            //检验该场地冲突
            Assert.assertEquals(XMJSONPath.readPath(venueAreaTools.checkMemberVenueBookingConflict(startMinute,endMinute,"0.00",groupId,memberId,reserveDay,areaId2,info),"$.result.conflict"),"true");
            //允许场地冲突并且预约场地
            Assert.assertEquals((venueAreaTools.checkAllowVenueBooking(startMinute,endMinute,"0.00",groupId,memberId,reserveDay,suiteId,areaId2,info)),"true");
            //预约子场地-2
            String voucherId2 = venueAreaTools.purchaseAreaTimes(startMinute,endMinute,suiteId,groupId,memberId,reserveDay,areaId2,info);//场地预约的订单id
            Thread.sleep(3000);
            String venueBookingRecordId2 = XMJSONPath.readPath(venueAreaTools.getByVoucher(voucherId2,info),"$.result.id");//场地预约的记录id
            venueAreaTools.getCheckInIdentifier(venueBookingRecordId2,info);//检验入场码生效

            JSONObject object = new JSONObject();
            object.put("identifier",venueBookingRecordId);
            object.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
            object.put("studioId",xmAppApi.getLoginInfo().getStudioId());
            object.put("brandId",xmAppApi.getLoginInfo().getBrandId());

            //调用请求
            xmAppApi.doRequest(RequestType.JSON,params,object.toJSONString(),headers).assetsSuccess(true);
            //检验b端预约详情变成已签到
            Assert.assertEquals(XMJSONPath.readPath(venueAreaTools.venueBookingRecordGetDetail(venueBookingRecordId),"$.result.state"),"RESERVED");
            Assert.assertEquals(XMJSONPath.readPath(venueAreaTools.venueBookingRecordGetDetail(venueBookingRecordId),"$.result.checkIn"),"true");

            //人工签到同一个码，提示已签到
            Assert.assertEquals(XMJSONPath.readPath(venueAreaTools.manualCheckIn(venueBookingRecordId),"$.message"),"签到失败，无需重复操作");
            //人工签到子场地-2成功
            Assert.assertEquals(XMJSONPath.readPath(venueAreaTools.manualCheckIn(venueBookingRecordId2),"$.message"),"操作成功!");
            //扫码签到子场地-2，提示已签到
            Assert.assertEquals(XMJSONPath.readPath(venueAreaTools.scanCheckIn(venueBookingRecordId2),"$.result.message"),"预约场次已签到，无需重复签到");
            //预约记录+2
            Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(venueAreaTools.pageVenueBooking(),"$.result.total"))==bookingNum+2);
            //检验预约失败记录=0
            Assert.assertEquals(XMJSONPath.readPath(venueAreaTools.countVenueBookingRefundFail(),"$.result"),"0");

            //清理数据
            //b端场地组移除场地
            venueAreaTools.unbindVenueAreas(suiteId,groupId);
            //b端删除场地组
            venueAreaTools.saveVenueAreaSuite(suiteId,"DELETE");
            //b端删除场地
            venueAreaTools.deleteVenueArea(groupId);
        }
    }
}
