package com.xiaomai.cases.polar.training;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.finance.order.OrderTools;
import com.xiaomai.cases.polar.member.Tools;
import com.xiaomai.cases.polar.schedule.camp.SelectTargetTrainingCampAndGetInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;

/**
 * @author adu
 * data 2024/8/1 13:55
 */

public class TestUnpaidCampOrder extends SelectTargetTrainingCampAndGetInfo {
    @Resource(name = "trainingTools")
    TrainingTools trainingTools;
    @Resource(name = "tools")
    Tools tools;
    @Resource(name = "orderTools")
    OrderTools orderTools;
    String memberId2 = "";
    String orderId = "";

    @BeforeClass
    @Override
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Training, "API_signOrderCamp", LoginAccount.ADU_PROD, Terminal.B, "adu");
        super.beforeTest();
    }

    @Test(description = "给学员报名训练营活动构造待支付订单")
    public void testUnpaidOrder() throws InterruptedException {
        //搜索目标会员
        String phone = "15658063769";
        memberId2 = trainingTools.searchTargerMember(phone);
        if (memberId2.isEmpty()) {
            memberId2 = tools.create("晨晨爸爸", phone).getString("result");
        }
        //报名接口做了重复调用限制，间隔3000秒，否则提示：调用过于频繁，请稍后重试
        Thread.sleep(3000);

        JSONObject body = new JSONObject();
        body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
        body.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        body.put("brandId", xmAppApi.getLoginInfo().getBrandId());

        body.put("salesmanId", xmAppApi.getLoginInfo().getAdminId());
        body.put("operationTime", TimeUtils.getCurrentTime());
        body.put("objectId", RandomStringUtil.randomString(20));
        body.put("memberId", memberId2);
        body.put("receivableAmount", this.price);

        JSONObject campInfo = new JSONObject();
        campInfo.put("campId", this.campId);
        body.put("camp", campInfo);
        body.put("paymentWays", new JSONArray());//支付方式传空
        xmAppApi.doRequest(RequestType.JSON, params, body.toString(), headers);
        Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(xmAppApi.getApi_response(),"$.success"))==true,"调用接口返回结果："+XMJSONPath.readPath(xmAppApi.getApi_response(),"$.message"));

        orderId = XMJSONPath.readPath(xmAppApi.getApi_response(), "$.result");
        //报名成功后根据会员手机号，在报名会员列表搜索报名数据
        trainingTools.getTrainingApplyRecordsList(this.campId, phone);
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result").size() == 1, "给学员报名后，在报名列表没查询到数据");
        //check订单 待支付状态
        Assert.assertEquals(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result").getJSONObject(0).getString("state"), "WAITING");

        //操作取消订单
        orderTools.cancel(orderId);
        trainingTools.getTrainingApplyRecordsList(this.campId, phone);
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result").size() == 0, "取消学员订单后，在报名列表中还能查询到数据");

    }

    @AfterTest(description = "删除此case创建的训练营活动-退单/取消订单后可以删除活动")
    public void delData() {
        if (!this.campId.isEmpty()) {
            trainingTools.deleteTraining(this.campId);
        }

    }
}

    