package com.xiaomai.utils;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class CommUtil {

    public static String getCurrentTime() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df.toString();
    }

    public static String getTimeStamp() {
        Long ct = System.currentTimeMillis();
        return ct.toString();
    }

    /**
     * 获取配置文件指出参数信息
     *
     * @return 返回一个文件对象
     */
    public static Properties getconfig() {
        Properties prop = null;

        try {
//          数据流的形式读取配置文件
            prop = new Properties();
            FileInputStream fis = new FileInputStream(System.getProperty("user.dir") +
                    "/src/main/resources/config.properties");
            prop.load(fis);
        } catch (Exception e) {
            e.printStackTrace();
        }

        return prop;

    }

    //把JavaBean转化为map
    public static Map<String, String> bean2map(Object bean) {
        Map<String, String> map = new HashMap<>();
        //获取JavaBean的描述器
        try {
            BeanInfo b = Introspector.getBeanInfo(bean.getClass(), Object.class);
            //获取属性描述器
            PropertyDescriptor[] pds = b.getPropertyDescriptors();
            for (PropertyDescriptor pd : pds) {
                String propertyName = pd.getName();
                Method m = pd.getReadMethod();
                Object properValue = m.invoke(bean);
                if (null != properValue) {
                    map.put(propertyName, properValue.toString());
                }
            }
        } catch (Exception e) {
            return null;
        } finally {
            return map;
        }

    }
}
