package com.xiaomai.cases.polar.training;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.CommUtil;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.springframework.stereotype.Component;
import org.testng.Assert;

import java.util.List;

/**
 * 训练营活动相关工具类
 *
 * @author adu
 * data 2024/7/3 15:12
 */
@Component("trainingTools")
public class TrainingTools extends XMBaseTest {
    String applyStartTime1 = String.valueOf(CommUtil.getWholeHourTimestamp()); //当前时间的整点
    String applyEndTime1 = CommUtil.oneKeyGetAddDay(1);//明天0点
    String openStartDate0 = applyEndTime1;
    String openEndDate0 = CommUtil.getNDayEndTimeTamp(2);//后天23：59：59

    long currentTimestamp = System.currentTimeMillis();
    // 在当前时间的基础上，加上5秒（5000毫秒）
    long futureTimestamp = currentTimestamp + 5000;
    String futureTimestampS = String.valueOf(futureTimestamp);


    /**
     * 同一个ApiModule下的登录信息封装出一个类，减少代码冗余
     *
     * @param apiName
     * @param userInfo
     */
    public void setUP(String apiName, DataUserInfo... userInfo) {
        dataApi.setApiModule(ApiModule.Polar_Training)
                .setApiName(apiName)
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfo);
    }

    /**
     * 新建训练营活动：保存并发布
     *
     * @param applyStartTime    报名开始时间
     * @param applyEndTime      报名结束时间
     * @param courseId          关联课程ID
     * @param openStartDate     开营开始时间
     * @param openEndDate       开营结束时间
     * @param price             售卖价格
     * @param title             训练营活动名称
     * @param totalClassHour    总课次数
     * @param traineeLowerLimit 开营人数
     * @param trainerList       上课教练
     * @param xcxSaleStatus     是否开启小程序售卖 YES，NO
     * @return 创建的训练营活动ID
     */
    public String createThenPublishTraining(String applyStartTime, String applyEndTime, String courseId, String openStartDate,
                                            String openEndDate, Double price, String title, int totalClassHour,
                                            int traineeLowerLimit, List<String> trainerList, String xcxSaleStatus) {
        setUP("API_createThenPublishTraining");
        JSONObject body = new JSONObject();
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId()); // 场馆
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("applyEndTime", applyEndTime);//报名结束时间
        body.put("applyStartTime", applyStartTime);//报名开始时间
        body.put("courseId", courseId); //关联课程ID
        body.put("creatorId", dataApi.getLoginInfo().getAdminId()); // 创建人即操作者
        body.put("openEndDate", openEndDate); //开营开始时间
        body.put("openStartDate", openStartDate); //开营结束时间
        body.put("price", price); //售卖价格
        body.put("surfaceUrl", "https://xiaomai-res.oss-cn-hangzhou.aliyuncs.com/xmfit/course_cover/training_camp_0.png"); // 默认活动封面图
        body.put("title", title); // 训练营活动名称：杭州自动化测试训练营
        body.put("totalClassHour", totalClassHour); // 总课次数
        body.put("traineeLowerLimit", traineeLowerLimit); // 开营人数
        body.put("traineeUpperLimit", 99); // 人数上限
        body.put("trainerList", trainerList); // 上课教练
        body.put("xcxSaleStatus", xcxSaleStatus); //是否开启小程序售卖
        body.put("underlinePrice", 99999.99); //划线价
        //图文介绍不设置，所以回归时check下 图文介绍
        dataApi.doRequest(RequestType.JSON, dataparams, body.toString(), dataheadrs);
        if (XMJSONPath.readPath(dataApi.getApi_response(), "$.message").equals("训练营名称不能重复")) {
            return "";
        }
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.success"), "true");
        return XMJSONPath.readPath(dataApi.getApi_response(), "$.result");
    }


    /**
     * 引用时可以继承 BaseCreateTrainingData 这个类，然后直接传值就可以
     * 价格0元，一键创建已发布且报名中的训练营活动
     *
     * @param courseId    需要传入课程ID
     * @param trainerList 需要传入教练
     * @return 活动ID
     */
    public String oneKeyCreateTraining(String courseId, List<String> trainerList) {
        setUP("API_createThenPublishTraining");
        String courseName = "训练营课程-感统课";
        String trainingTitle = "三期36天训练营感统课" + RandomStringUtil.randomString(5);
        JSONObject body = new JSONObject();
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId()); // 场馆
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("applyEndTime", applyEndTime1);//报名结束时间
        body.put("applyStartTime", futureTimestampS);//报名开始时间，晚于当前时间5秒
        body.put("courseId", courseId); //关联课程ID
        body.put("creatorId", dataApi.getLoginInfo().getAdminId()); // 创建人即操作者
        body.put("openEndDate", openEndDate0); //开营结束时间
        body.put("openStartDate", openStartDate0); //开营开始时间
        body.put("price", 0); //售卖价格
        body.put("surfaceUrl", "https://xiaomai-res.oss-cn-hangzhou.aliyuncs.com/xmfit/course_cover/training_camp_0.png"); // 默认活动封面图
        body.put("title", trainingTitle);
        body.put("totalClassHour", 2); // 总课次数
        body.put("traineeLowerLimit", 1); // 开营人数
        body.put("traineeUpperLimit", 99); // 人数上限
        body.put("trainerList", trainerList); // 上课教练
        body.put("xcxSaleStatus", "YES"); //开启小程序售卖
        body.put("underlinePrice", 19.9); //划线价
        //图文介绍不设置，所以回归时check下 图文介绍
        dataApi.doRequest(RequestType.JSON, dataparams, body.toString(), dataheadrs).assetsSuccess(true);
        return XMJSONPath.readPath(dataApi.getApi_response(), "$.result");


    }

    /**
     * 提供训练营活动名称，课程ID和教练ID 快速创建未发布的活动
     *
     * @param title       训练营活动名称，可以传空，有默认值
     * @param courseId
     * @param trainerList
     * @return
     */
    public String createTrainingNoPublish(String title, String courseId, List<String> trainerList) {
        setUP("API_createTrainingNoPublish");
        JSONObject body = new JSONObject();
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId()); // 场馆
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("applyEndTime", applyEndTime1);//报名结束时间
        body.put("applyStartTime", applyStartTime1);//报名开始时间
        body.put("courseId", courseId); //关联课程ID
        body.put("creatorId", dataApi.getLoginInfo().getAdminId()); // 创建人即操作者
        body.put("openEndDate", openEndDate0); //开营开始时间
        body.put("openStartDate", openStartDate0); //开营结束时间
        body.put("price", 0.01); //售卖价格
        body.put("surfaceUrl", "https://xiaomai-res.oss-cn-hangzhou.aliyuncs.com/xmfit/course_cover/training_camp_0.png"); // 默认活动封面图
        body.put("title", title); // 训练营活动名称："杭州自动化测试训练营-未发布"
        if (title.isEmpty()) {
            body.put("title", "杭州自动化测试训练营-未发布");
        }

        body.put("totalClassHour", 2); // 总课次数
        body.put("traineeLowerLimit", 2); // 开营人数
        body.put("traineeUpperLimit", 99); // 人数上限
        body.put("trainerList", trainerList); // 上课教练
        body.put("xcxSaleStatus", "YES"); //开启小程序售卖
        body.put("underlinePrice", 99999.99); //划线价
        //图文介绍不设置，所以回归时check下 图文介绍
        dataApi.doRequest(RequestType.JSON, dataparams, body.toString(), dataheadrs).assetsSuccess(true);
        return XMJSONPath.readPath(dataApi.getApi_response(), "$.result");
    }

    /**
     * 删除训练营活动
     *
     * @param id 活动ID
     */
    public void deleteTraining(String id) {
        setUP("API_deleteTraining");
        JSONObject body = new JSONObject();
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("id", id);
        dataApi.doRequest(RequestType.JSON, dataparams, body.toString(), dataheadrs).assetsSuccess(true);
    }

    /**
     * 根据训练营活动名称全局搜索
     *
     * @param title 活动名称
     */
    public void commonSearchTraining(String title) {
        setUP("API_commonSearchTraining");
        JSONObject body = new JSONObject();
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("title", title);
        dataApi.doRequest(RequestType.JSON, dataparams, body.toString(), dataheadrs).assetsSuccess(true);
    }

    /**
     * 训练营活动列表搜索
     *
     * @param courseId  根据关联课程搜索，可传""
     * @param stateList 根据活动状态搜索
     *                  不指定时传空，new ArrayList<>()
     *                  未发布：UNPUBLISHED
     *                  报名未开始：APPLY_NOT_START
     *                  报名中：APPLYING
     *                  待开营：TO_BE_OPEN
     *                  进行中：OPENING
     *                  已结束：CLOSED
     *                  已取消：CANCEL
     */
    public void searchTrainingList(String courseId, String trainingName, List<String> stateList) {
        setUP("API_searchTrainingList");
        JSONObject body = new JSONObject();
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("current", 0);
        body.put("size", 20);
        body.put("courseId", courseId);
        body.put("stateList", stateList);
        if (!trainingName.isEmpty()) {
            body.put("title", trainingName);
        }

        dataApi.doRequest(RequestType.JSON, dataparams, body.toString(), dataheadrs).assetsSuccess(true);
    }

    /**
     * 创建/编辑是训练营名称重名校验
     *
     * @param title 活动名称
     * @return 返回校验结果 true 是有重名不通过，false 是无重名 可创建
     */
    public Boolean checkTrainingTitleDuplicate(String title) {
        setUP("API_checkTrainingTitleDuplicate");
        JSONObject body = new JSONObject();
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("title", title);
        dataApi.doRequest(RequestType.JSON, dataparams, body.toString(), dataheadrs).assetsSuccess(true);
        return Boolean.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.result"));
    }

    /**
     * 查看训练营活动详情：基础信息
     *
     * @param id 活动ID
     */
    public void findTrainingDetailById(String id) {
        setUP("API_findTrainingDetailById");
        JSONObject body = new JSONObject();
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("id", id);
        dataApi.doRequest(RequestType.JSON, dataparams, body.toString(), dataheadrs).assetsSuccess(true);

    }


}

