package com.xiaomai.cases.polar.admin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;
import org.springframework.stereotype.Component;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.admin
 * @Author: xuyamei
 * @CreateTime: 2024-02-29  10:00
 * @Description: 员工工具类
 * @Version: 1.0
 */
@Component("adminTools")
public class AdminTools extends XMBaseTest {
    /**
     * @description:添加员工
     * @author: xuyamei
     * @date:  2024/2/29 13:59
     * @param role：角色
     * @param dataUserInfos
     * @return: com.alibaba.fastjson.JSONObject  返回的是请求参数
     **/
    public JSONObject addStudioAdmin(String role,String name, DataUserInfo...dataUserInfos){
        dataApi.setApiModule(ApiModule.Polar_Admin)
                .setApiName("API_addStudioAdmin")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject body = new JSONObject();
        body.put("phone", RandomStringUtil.randomMobile("103"));
        if (name.equals("")){
            name = RandomStringUtil.random_name();

        }
        body.put("name", name);
        body.put("nickName", name);
        JSONObject avatar = new JSONObject();
        avatar.put("content",name.charAt(name.length() - 1));
        body.put("avatar",avatar);  // 员工头像未设置取昵称最后一个字
        body.put("gender","MAN");
        body.put("userId",dataApi.getLoginInfo().getUser());
        body.put("brandId",dataApi.getLoginInfo().getBrandId());
        body.put("studioId",dataApi.getLoginInfo().getStudioId());
        body.put("operatorId",dataApi.getLoginInfo().getAdminId());

        JSONArray roles = new JSONArray();  // 角色
        JSONObject teaching = new JSONObject();
        JSONArray coachTeachingTypes = new JSONArray(); // LEAGUE_CLASS, PERSONAL_TRAINERS, TRAINING_CAMP   "团课", "私教", "训练营"

        switch(role){
            case "教练":
                roles.add("StudioCoach");
                body.put("roles", roles);
                teaching.put("teaching", true); // 是否授课,为true需要传授课的类型
                coachTeachingTypes.add("LEAGUE_CLASS");  // 团课
                coachTeachingTypes.add("PERSONAL_TRAINERS");  //私教
                coachTeachingTypes.add("TRAINING_CAMP");  //训练营
                teaching.put("coachTeachingTypes",coachTeachingTypes);
                body.put("teaching",teaching);
                break;
            case "销售主管":
                roles.add("StudioSaleManager");
                teaching.put("teaching", false);
                body.put("teaching",teaching); // 是否授课
                body.put("roles", roles);
                break;
            case "财务":
                roles.add("StudioFinance");
                teaching.put("teaching", false);
                body.put("teaching",teaching); // 是否授课
                body.put("roles", roles);
                break;
            case "前台":
                roles.add("StudioReception");
                teaching.put("teaching", false);
                body.put("teaching",teaching); // 是否授课
                body.put("roles", roles);
                break;
            default: // 默认店长
                roles.add("StudioOwner");
                teaching.put("teaching", false);
                body.put("teaching",teaching); // 是否授课
                body.put("roles", roles);

        }

        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
        return body;
    }

    /**
     * @description:检验员工手机号是否存在
     * @author: xuyamei
     * @date:  2024/2/29 14:04
     * @param phone
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONObject checkExistInStudio(String phone){
        dataApi.setApiModule(ApiModule.Polar_Admin)
                .setApiName("API_checkExistInStudio")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();
        String body = "{\"phone\": \""+phone+"\"}";
        dataApi.doRequest(RequestType.JSON,dataparams,body,dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * @description:获取员工信息
     * @author: xuyamei
     * @date:  2024/2/29 16:47
     * @param adminId:员工id
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONObject getStudioAdmin(String adminId,DataUserInfo...dataUserInfo){
        dataApi.setApiModule(ApiModule.Polar_Admin)
                .setApiName("API_getStudioAdmin")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfo);

        String body = "{\"id\":\""+adminId+"\"}";
        dataApi.doRequest(RequestType.JSON,dataparams,body,dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }
    /**
     * @description:查询员工列表数据
     * @author: xuyamei
     * @date:  2024/2/29 17:58
     * @param body：请求参数
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONObject pageStudioAdmin(String body,DataUserInfo...userInfo){
        dataApi.setApiModule(ApiModule.Polar_Admin)
                .setApiName("API_pageStudioAdmin")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfo);

        dataApi.doRequest(RequestType.JSON,dataparams,body,dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }


    /**
     * @description:查询帐号下可切换的场馆列表
     * @author: yangjian
     * @date:  2024/2/29 17:58
     * @param body：请求参数
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONObject pagelistAdmins(String body){
        dataApi.setApiModule(ApiModule.Polar_Admin)
                .setApiName("API_listAdmins")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        dataApi.doRequest(RequestType.JSON,dataparams,body,dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }



    /**
     * @description:删除角色
     * @author: xuyamei
     * @date:  2024/4/19 17:25
     * @param code
     * @return: void
     **/
    public void studioRoleRemove(String code){
        dataApi.setApiModule(ApiModule.Polar_Admin)
                .setApiName("API_studioRole_remove")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        String body = "{\"roleCode\":\""+code+"\"}";
        dataApi.doRequest(RequestType.JSON,dataparams,body,dataheadrs).assetsSuccess(true);

    }

    /**
     * @description:角色列表
     * @author: xuyamei
     * @date:  2024/4/19 17:45
     * @return:
     **/
    public JSONObject studioRoleListByStudioId(){
        dataApi.setApiModule(ApiModule.Polar_Admin)
                .setApiName("API_studioRole_listByStudioId")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        dataApi.doRequest(RequestType.JSON,dataparams,"",dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();

    }


    public JSONObject getDetailStudioRole(String code){
        dataApi.setApiModule(ApiModule.Polar_Admin)
                .setApiName("API_studioRole_getDetail")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        String url= dataApi.getUrl()+"&roleCode="+code;
        dataApi.setUrl(url);
        dataApi.doRequest(RequestType.JSON,dataparams,"",dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();

    }



    public void createStudioRole(String name){
        dataApi.setApiModule(ApiModule.Polar_Admin)
                .setApiName("API_studioRole_create")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        String body = "{\"roleName\": \""+name+"\",\n" +
                "        \"permissions\":\n" +
                "         [\"FitHeadPage\", \"FitViewExperienceCard\", \"FitManageExperienceCard\", \"FitViewSoldExperienceCard\", \"FitManageSoldExperienceCard\", \"FitSeeMember\", \"FitLoseMember\", \"FitEditMember\", \"FitAllocateMember\", \"FitSeeMemberCard\", \"FitManageMemberCard\", \"FitSeeSoldMemberCard\", \"FitManageSoldMemberCard\", \"FitSeeTrainingCamp\", \"FitEditTrainingCamp\", \"FitSeeSoldTrainingCamp\", \"FitEditSoldTrainingCamp\", \"FitSeeGroupSchedule\", \"FitManageGroupSchedule\", \"FitSeePersonalSchedule\", \"FitManagePersonalSchedule\", \"FitManageTrainingCampSchedule\", \"FitBooking\", \"FitCancelBooking\", \"FitSign\", \"FitSeeBookingRecord\", \"FitIncomeExpense\", \"FitSeeOrder\", \"FitEditOrder\", \"FitSeeXmPay\", \"FitManageXmPay\", \"FitLog\", \"FitSeeAdmin\", \"FitInfo\", \"FitBrandInfo\", \"FitReminderSet\", \"FitSms\", \"FitLabel\", \"FitCourseCategory\", \"FitVenue\", \"FitBookingRuleSet\", \"FitSaleRule\", \"FitPayment\"],\n" +
                "        \"configMap\": {\n" +
                "        \"memberAccess\": false,\n" +
                "        \"scheduleAccess\": false,\n" +
                "        \"reserveAccess\": false,\n" +
                "        \"followUpAccess\": true,\n" +
                "        \"importAccess\": true,\n" +
                "        \"exportAccess\": true,\n" +
                "        \"taskAccess\": false,\n" +
                "        \"potentialPhoneMask\": true,\n" +
                "        \"memberPhoneMask\": true,\n" +
                "        \"historyPhoneMask\": false\n" +
                "        }}";
        dataApi.doRequest(RequestType.JSON,dataparams,body,dataheadrs).assetsSuccess(true);
    }

    /**
     * @description:检查手机号是品牌下场馆的主账号
     * @author: xuyamei
     * @date:  2024/7/1 11:06
     * @param dataUserInfo
     * @return: com.alibaba.fastjson.JSONArray
     **/
    public JSONArray findStudioBossInBrand(DataUserInfo...dataUserInfo) {
        dataApi.setApiModule(ApiModule.Polar_Admin)
                .setApiName("API_findStudioBossInBrand")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfo);

        JSONObject body = new JSONObject();
        body.put("id", dataApi.getLoginInfo().getAdminId());
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONArray("result");
    }


    /**
     * @description:获取手机号在品牌下对应的员工
     * @author: xuyamei
     * @date:  2024/7/1 11:20
     * @param phone
     * @param dataUserInfo
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONObject getAdminByPhone(String phone,DataUserInfo...dataUserInfo) {
        dataApi.setApiModule(ApiModule.Polar_Admin)
                .setApiName("API_getAdminByPhone")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfo);

        JSONObject body = new JSONObject();
        body.put("phone", phone);
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONObject("result");
    }

    /**
     * @description 复用已有员工信息
     * @author: xuyamei
     * @date:  2024/7/1 11:37
     * @param body ：请求参数
     * @param dataUserInfo
     * @return: void
     **/
    public void useBrandAdmin(JSONObject body,DataUserInfo...dataUserInfo) {
        dataApi.setApiModule(ApiModule.Polar_Admin)
                .setApiName("API_useBrandAdmin")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfo);


        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
    }


    /**
     * @description:校验场馆员工离职
     * @author: xuyamei
     * @date:  2024/7/1 16:16
     * @param userInfo
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONObject checkDepartStudioAdmin(String id,DataUserInfo...userInfo){
        dataApi.setApiModule(ApiModule.Polar_Admin)
                .setApiName("API_checkDepartStudioAdmin")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfo);

        JSONObject body = new JSONObject();
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("id", id);
        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONObject("result");
        
    }

    /**
     * @description:校验取消授课或者移除所授课程
     * @author: xuyamei
     * @date:  2024/7/1 16:54
     * @param id ：员工id
     * @param teaching ：是否授课
     * @param coachTeachingTypes ：授课类型 ["LEAGUE_CLASS","PERSONAL_TRAINERS", "TRAINING_CAMP"]
     * @param userInfo
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONObject checkModifyTeaching(String id,boolean teaching,JSONArray coachTeachingTypes,DataUserInfo...userInfo){
        dataApi.setApiModule(ApiModule.Polar_Admin)
                .setApiName("API_checkModifyTeaching")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfo);

        JSONObject body = new JSONObject();
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("id",id);

        JSONObject teach = new JSONObject();
        teach.put("teaching", teaching); // 是否授课
        teach.put("coachTeachingTypes", coachTeachingTypes);
        body.put("teaching",teach);
        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONObject("result");

    }




}
