package com.xiaomai.cases.polar.clue;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @Author zxy
 * @Description
 * @Date 2024/3/14 17:08
 */
public class TestGetDetailById extends XMBaseTest {
    MemberTools memberTools = new MemberTools();
    String id;
    @BeforeMethod
    public void beforeTest(){

        xmAppApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_findDetailById")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("zyx")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @Test(description = "会员详情")
    public void testGetDetailById() {
        String name = "自动化潜在会员" + RandomStringUtil.randomString(3);
        String phone = RandomStringUtil.randomMobile("666");


        //若全部线索有数据，则取第一条数据；若无数据则新建一个线索
        JSONArray array = memberTools.searchMember("全部线索","POTENTIAL").getJSONObject("result").getJSONArray("records");
        int size = array.size();
        if(size == 0){

            id = memberTools.create(name,phone).getString("result");
        }
        else {
            id = array.getJSONObject(0).getString("id");
        }

        JSONObject object = new JSONObject();
        object.put("memberId",id);

        xmAppApi.doRequest(RequestType.JSON,params,object.toString(),headers).assetsSuccess(true);
        JSONObject res = xmAppApi.getBodyInJSON();

        Assert.assertEquals(res.getJSONObject("result").getString("id"),id);

    }

    @Test(description = "会员详情-id为空")
    public void testGetDetailById_1() {

        JSONObject object = new JSONObject();
        object.put("memberId","");

        xmAppApi.doRequest(RequestType.JSON,params,object.toString(),headers).assetsSuccess(false);
        Assert.assertEquals(XMJSONPath.readPath(xmAppApi.getBodyInJSON(), "$.message"), "会员id不能为空");

    }
}
