package com.xiaomai.cases.polar.coupon;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.lunar.user.UserTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestListMemberReceivedCoupon extends XMBaseTest {
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Lunar_Coupon)
                .setApiName("API_listMemberReceivedCoupon")
                .setLoginUser(LoginAccount.GYM_MINIAPPC)
                .setTerminal(Terminal.minApp);

        dal.setCase_owner("yj")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @Test(description = "小程序我的优惠券")
    public void fetchOrderWaitUse() {
        CouponMInTools CouponMIntools =new CouponMInTools();
        CouponMIntools.getPageConfig();//首页获取首页的配置
        Assert.assertTrue(XMJSONPath.readPath(dataApi.getApi_response(),"$.result.moduleConfigList[11].config.ids[0]").equals("1823600619080667137"),"非目标优惠券");

        String id =XMJSONPath.readPath(dataApi.getApi_response(),"$.result.moduleConfigList[11].config.ids[0]");//小程序首页，拿配置返回的优惠券id


        CouponMIntools.pageStudioCoupon(id);//优惠券查看更多列表
        Assert.assertTrue(XMJSONPath.readPath(dataApi.getApi_response(),"$.result.records[0].id").equals("1823600619080667137"),"第一张非目标优惠券，可能没有配置，可能剩余张数不足");


        JSONObject Result=CouponMIntools.coupon_get(id);//查看优惠券详情
        int inventory=Integer.parseInt(Result.getJSONObject("result").getString("inventory"));
        Assert.assertEquals(inventory>=1,true,"自动化小程序优惠券（勿），剩余张数不足，需要去B端修改剩余张数");

        UserTools userTools=new UserTools();
        String receiverId = userTools.getMemberInfo().getString("memberId");//同memberId，获取receiverId

        CouponMIntools.listMemberReceivedCoupon(receiverId,"AVAILABLE");
        int count= XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(),"$.result").size();

        CouponMIntools.claim(id,receiverId);//领取优惠券
        JSONObject Result1=CouponMIntools.coupon_get(id);//查看优惠券详情
        int inventory1=Integer.parseInt(Result1.getJSONObject("result").getString("inventory"));//获取领取优惠券后，剩余张数
        Assert.assertEquals(inventory,inventory1+1);//领取优惠券后，断言优惠券张数-1

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("receiverId", receiverId);
        jsonObject.put("status", "AVAILABLE");//AVAILABLE待使用；USED已使用；EXPIRED已过期

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);

        CouponMIntools.listMemberReceivedCoupon(receiverId,"AVAILABLE");
        int count1= XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(),"$.result").size();
        Assert.assertEquals(count1,count+1);//领取优惠券后，我的优惠券列表+1


    }
}
