package com.xiaomai.cases.polar.eleContract;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.util.Random;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.eleContract
 * @Author: xuyamei
 * @CreateTime: 2024-08-05  15:25
 * @Description: 设置租户的预警配置
 * @Version: 1.0
 */
public class TestSetBalanceWarning extends BaseTestImpl {
    @Resource(name = "eleContractTools")
    EleContractTools eleContractTools;

    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_EleContract,"API_setBalanceWarning", LoginAccount.DZHT_PROD, Terminal.B,"xym");
        super.beforeTest();
    }

    @Test
    public void testSetBalanceWarning(){
        // 获取预警id
        JSONObject balanceWarning = eleContractTools.getBalanceWarning();
        String id = balanceWarning.getString("id");

        Random random = new Random();
        int amount = random.nextInt(100);
        JSONObject body = new JSONObject();
        body.put("warnAmount",amount);
        body.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        body.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        body.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
        body.put("notifyPhone","13120057004");
        body.put("id",id);

        xmAppApi.doRequest(RequestType.JSON,params,body.toString(),headers).assetsSuccess(true);
        // 设置完成后查询设置的预警值
        balanceWarning = eleContractTools.getBalanceWarning();
        String[] keys = {"warnAmount","notifyPhone","id"};
        String[] values = {amount+"","13120057004",id};
        for (int i = 0; i < keys.length; i++){
            Assert.assertEquals(balanceWarning.getString(keys[i]),values[i]);
        }
    }
}
