package com.xiaomai.cases.polar.finance.axf;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.finance.axf
 * @Author: xuyamei
 * @CreateTime: 2024-12-25  14:13
 * @Description: 统计先学后付订购单 已扣总计、实扣总计
 * @Version: 1.0
 */
public class TestAXFAggOrder extends BaseTestImpl {
    AXFTools axfTools = new AXFTools();
    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_Finance,"API_axf_aggOrder", LoginAccount.GYM_PROD, Terminal.B,"xym");
        super.beforeTest();
    }

    @Test
    public void testAXFAggOrder(){
        String body = "{\"current\":0,\"size\":20,\"studioId\":\""+xmAppApi.getLoginInfo().getStudioId()+"\",\"brandId\":\""+xmAppApi.getLoginInfo().getBrandId()+"\",\"commodityCardType\":\"DEPOSIT_CARD\",\"voucherBusinessNo\":null,\"thirdOrderNo\":null,\"operatorId\":\""+xmAppApi.getLoginInfo().getAdminId()+"\"}";
        JSONObject response = axfTools.getAXFPageOrder(body);
        // 查询列表数据（已经扣款的数据）
        int total = response.getJSONObject("result").getJSONArray("records").size();
        double receivedAmount = 0.00;
        double receivedActualAmount = 0.00;
        String thirdOrderNo = "";
        for (int i = 0; i < total; i++){
            receivedAmount = response.getJSONObject("result").getJSONArray("records").getJSONObject(i).getDouble("receivedAmount");

            if (receivedAmount > 0){
                // 查询详情数据
                receivedActualAmount = response.getJSONObject("result").getJSONArray("records").getJSONObject(i).getDouble("receivedActualAmount");
                thirdOrderNo = response.getJSONObject("result").getJSONArray("records").getJSONObject(i).getString("thirdOrderNo");

                body = "{\"current\":0,\"size\":20,\"studioId\":\""+xmAppApi.getLoginInfo().getStudioId()+"\",\"brandId\":\""+xmAppApi.getLoginInfo().getBrandId()+"\",\"commodityCardType\":\"DEPOSIT_CARD\",\"voucherBusinessNo\":null,\"thirdOrderNo\":"+thirdOrderNo+",\"operatorId\":\""+xmAppApi.getLoginInfo().getAdminId()+"\"}";
                xmAppApi.doRequest(RequestType.JSON,params,body,headers).assetsSuccess(true);
                response = xmAppApi.getBodyInJSON();
                // 验证统计条返回的数据与列表统计数据一致
                Assert.assertEquals(response.getJSONObject("result").getString("receivedActualAmount").equals(String.valueOf(receivedActualAmount)), true);
                break;
            }
        }
    }

}
