package com.xiaomai.cases.polar.member;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.springframework.stereotype.Component;

import java.util.List;
@Component("tools")
public class Tools extends XMBaseTest {


    /**
     * @param
     * @description:获取会员管理列表
     * @param searchType:查询类型 POTENTIAL, NORMAL, HISTORY
     * @param status:会员状态 POTENTIAL, NORMAL, HISTORY
     * @author: yangfangfang
     **/
    public JSONObject search(String searchType,String status, DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_searchMember")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);


        JSONObject jsonObject=new JSONObject();
        jsonObject.put("current",0);
        jsonObject.put("size",20);
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
        jsonObject.put("searchType",searchType);

        JSONArray statusList=new JSONArray();
        statusList.add(status);
        jsonObject.put("statusList",statusList);

        jsonObject.put("resourceId",null);
        jsonObject.put("creatorId",null);
        jsonObject.put("wechatBindStatus",null);
        jsonObject.put("saleId",null);
        jsonObject.put("birthdayEnd",null);
        jsonObject.put("createdEnd",null);
        jsonObject.put("createdStart",null);
        jsonObject.put("tags",null);
        jsonObject.put("coachId",null);

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }


    /**
     * @param
     * @description:添加线索
     * @param name:姓名
     * @param phone:手机号
     * @param
     * @author: yangfangfang
     **/

    public JSONObject create(String name,String phone,DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_create")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject object = new JSONObject();
        object.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        object.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        object.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
        object.put("creatorId",xmAppApi.getLoginInfo().getAdminId());
        object.put("status","POTENTIAL");
        object.put("name",name);
        object.put("phone",phone);
        object.put("gender","UNKNOWN");
        object.put("position","INITIAL");
        object.put("saleId","-1");

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }


    /**
     * @param
     * @description:搜索会员
     * @param content:姓名/手机号
     * @param status:POTENTIAL, NORMAL, HISTORY
     * @param
     * @author: yangfangfang
     **/

    public JSONObject commonSearch(String content,String status, DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_commonSearch")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject object = new JSONObject();
        object.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        object.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        object.put("operatorId",xmAppApi.getLoginInfo().getStudioId());
        object.put("content",content);

        JSONArray statusList=new JSONArray();
        statusList.add(status);
        object.put("statusList",statusList);
        object.put("followerId",null);
        object.put("position",null);
        object.put("dataPermissionFilter",true);

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

}
