package com.xiaomai.cases.polar.points;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.springframework.stereotype.Component;


@Component("pointsMinTools")//小程序会员积分工具类
public class PointsMInTools extends XMBaseTest {
    public void setUp(String name, DataUserInfo...dataUserInfo) {
        dataApi.setApiModule(ApiModule.Lunar_Points)
                .setApiName(name)
                .setTerminal(Terminal.B);//这个到时候要改
    }
    /**
     * @param
     * @description:小程序-我的-获取积分
     * @author: yangjian
     * @param memberId 会员id


     **/
    public JSONObject memberPoint_getAccount(String memberId, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Lunar_Points)
                .setApiName("API_memberPoint_getAccount")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("memberId", memberId);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }


    /**
     * @param
     * @description:小程序-我的-获取积分
     * @author: yangjian
     * @param memberId 会员id


     **/
    public JSONObject findStatementPage(String memberId,String incTag, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Lunar_Points)
                .setApiName("API_findStatementPage")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("current", 0);
        jsonObject.put("size", 20);
        jsonObject.put("memberId", memberId);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        if (!incTag.equals("")){
            jsonObject.put("incTag", incTag);//true为获取tab;false为消耗tab
        }

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }
}
