package com.xiaomai.cases.polar.reserve.personal;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.polar.course.CourseTools;
import com.xiaomai.cases.polar.reserve.ReserveTools;
import com.xiaomai.cases.polar.setting.courseCategory.CourseCategoryTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.util.Random;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.reserve.personal
 * @Author: xuyamei
 * @CreateTime: 2024-07-24  17:20
 * @Description: 获取私教课程的可约时间块
 * @Version: 1.0
 */
public class TestGetPersonalTimeBlocks extends BaseTestImpl {
    @Resource(name = "reserveTools")
    ReserveTools reserveTools;

    @Resource(name = "courseTools")
    CourseTools courseTools;

    @Resource(name = "courseCategoryTools")
    CourseCategoryTools courseCategoryTools;

    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_Reserve,"API_getPersonalTimeBlocks", LoginAccount.GYM_PROD, Terminal.B,"xym");
        super.beforeTest();
    }
    private String coachedId;
    private String courseId;

    @Test
    public void TestGetPersonalTimeBlocks() {
        // 获取到员工
        // 获取教练列表
        JSONObject pageStudioPersonalCoach = reserveTools.pageStudioPersonalCoach("");
        int total = pageStudioPersonalCoach.getInteger("total");
        Random rand = new Random();
        // 随机取1个教练
        coachedId = pageStudioPersonalCoach.getJSONArray("records").getJSONObject(rand.nextInt(total>10?10:total)).getString("id");

        // 获取到相关私教课程
        // 获取课程分类
        String categoryId = courseCategoryTools.getCourseCategoryPage("私教课分类"+ TimeUtils.getCurrentTime());
        courseId = courseTools.getPersonalOrGroupCourseId("PERSONAL","普拉提器械课程",categoryId,"STUDIO","ONE_TO_ONE",1,1).getString(0);
        String courseName = courseTools.getPersonalOrGroupCourseId("PERSONAL","普拉提器械课程",categoryId,"STUDIO","ONE_TO_ONE",1,1).getString(1);
        // 编辑私教课程教练添加到课程中
        courseTools.editPersonalCourse(categoryId,courseId,courseName,1,coachedId,"1");

        // 创建私教特殊可约时间
        JSONObject specialTimeInfoRequest = new JSONObject();
        // 可约时间类型
        specialTimeInfoRequest.put("dutyType", "ON_DUTY");

        // 设置特定日期
        JSONArray selectedDates = new JSONArray();
        selectedDates.add(TimeUtils.getTodayTime());
        specialTimeInfoRequest.put("selectedDates", selectedDates);

        // 如果是可约时间非全天休息，则传可约时间段
        // 时间段 00:00 ~ 23:59
        JSONArray timePeriodInfos = new JSONArray();
        JSONObject timeInfo = new JSONObject();
        timeInfo.put("minuteOffset", 0);
        timeInfo.put("spanMinutes", 1380);
        timePeriodInfos.add(timeInfo);
        specialTimeInfoRequest.put("timePeriodInfos", timePeriodInfos);
        // 设置特殊可约时间
        reserveTools.createSpecialDate(coachedId,"ON_DUTY",specialTimeInfoRequest);

        // 检查可约时间块
        JSONArray personalTimeBlocks = reserveTools.getPersonalTimeBlocks(coachedId,courseId,TimeUtils.getTodayTime());
        Assert.assertTrue(personalTimeBlocks.size()>0,"设置老师今天时间可约，但是返回的结果是空的");

    }


    @Test(priority = 1)
    public void TestGetPersonalTimeBlocks_OFF() {

        // 创建私教特殊可约时间为休息
        JSONObject specialTimeInfoRequest = new JSONObject();
        // 可约时间类型
        specialTimeInfoRequest.put("dutyType", "OFF_DUTY");

        // 设置特定日期
        JSONArray selectedDates = new JSONArray();
        selectedDates.add(TimeUtils.getTodayTime());
        specialTimeInfoRequest.put("selectedDates", selectedDates);

        // 设置特殊可约时间
        reserveTools.createSpecialDate(coachedId,"OFF_DUTY",specialTimeInfoRequest);

        // 检查可约时间块
        JSONArray personalTimeBlocks = reserveTools.getPersonalTimeBlocks(coachedId,courseId,TimeUtils.getTodayTime());
        Assert.assertTrue(personalTimeBlocks.size()==0,"设置老师今天时间休息，但是返回了数据");

    }

    @Test(priority = 2)
    public void del(){
        // 查询特殊可约时间列表
        JSONArray specialTimeVOS = reserveTools.getPersonalCoachTime(coachedId,"specialTimeVOS");

        for (int i = 0; i < specialTimeVOS.size(); i++){
            String id = specialTimeVOS.getJSONObject(i).getJSONArray("recordIds").getString(0);
            // 删除查询到的特殊可约时间
            reserveTools.deleteSpecialDate(id);
        }

    }
}
