package com.xiaomai.cases.polar.setting.pay;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;



public class TestUpdate extends XMBaseTest {

    PayTools payTools=new PayTools();

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_update")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("yff")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }


    @Test(description = "修改通用配置支付方式-关闭/开启")
    public void testUpdate(){

        //修改默认支付方式

        String getListStatus=payTools.getList().getJSONArray("result").getJSONObject(1).getString("status");

        if(getListStatus == "ON"){
            JSONObject update=payTools.update("1798566848871395329","线下微信","OFF");
            Assert.assertEquals(update.getString("success"),"true","修改默认支付方式失败");
        }
        else if (getListStatus == "OFF"){
            JSONObject update=payTools.update("1798566848871395329","线下微信","ON");
            Assert.assertEquals(update.getString("success"),"true","修改默认支付方式失败");
        }



        //修改自定义方式

        JSONObject saveResult=payTools.save("被修改自动化支付方式");
        String saveId=saveResult.getString("result");

        JSONObject OFF=new JSONObject();
        OFF.put("id",saveId);
        OFF.put("name","被修改自动化支付方式");
        OFF.put("tenantId",xmAppApi.getLoginInfo().getBrandId());
        OFF.put("tenantType","BRAND");// "BRAND", "STUDIO", "INVALID" ]租户类型：BRAND-品牌；STUDIO-场馆[TenantTypeEnum]
        OFF.put("status","OFF");
        OFF.put("category","PAYMENT");
        OFF.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        OFF.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        OFF.put("operatorId",xmAppApi.getLoginInfo().getAdminId());


        try {
            Thread.sleep(2000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        JSONObject ON=new JSONObject();
        ON.put("id",saveId);
        ON.put("name","被修改自动化支付方式");
        ON.put("tenantId",xmAppApi.getLoginInfo().getBrandId());
        ON.put("tenantType","BRAND");// "BRAND", "STUDIO", "INVALID" ]租户类型：BRAND-品牌；STUDIO-场馆[TenantTypeEnum]
        ON.put("status","ON");
        ON.put("category","PAYMENT");
        ON.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        ON.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        ON.put("operatorId",xmAppApi.getLoginInfo().getAdminId());


        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        //获取支付方式列表
        JSONArray getList=payTools.getList().getJSONArray("result");
        int length = getList.size();
        String lastCode = getList.getJSONObject(length - 1).getString("code");

        //校验该支付方式是否使用过
        boolean checkPaymentWayUsedResult=payTools.checkPaymentWayUsed(saveId,lastCode).getBoolean("result");

        if(checkPaymentWayUsedResult == false){
            //删除新建的自定义支付方式
            JSONObject removeResult=payTools.remove(saveId);
            Assert.assertEquals(removeResult.getString("success"),"true","删除新建自定义支付方式失败");
        }

    }
}
