package com.xiaomai.cases.polar.finance.cashier;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestListRelatedRecordsById extends XMBaseTest {
    CashierTools cashierTools=new CashierTools();

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_listRelatedRecordsById")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("yff")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "根据当前流水id查关联的流水")
    public void testListRelatedRecordsById(){

        //获取交易记录（流水）列表-退款成功流水
        JSONObject result=cashierTools.page_sift("WX","REFUND_ORDER","REFUND_SUCCESS");
        int total=Integer.parseInt(result.getJSONObject("result").getString("total"));

        if(total>0) {

            String refundId=result.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");//流水ID
            //退款成功流水查看关联交易
            JSONObject refund = new JSONObject();
            refund.put("id", refundId);
            refund.put("brandId", xmAppApi.getLoginInfo().getBrandId());
            refund.put("studioId", xmAppApi.getLoginInfo().getStudioId());
            refund.put("operatorId", xmAppApi.getLoginInfo().getAdminId());

            xmAppApi.doRequest(RequestType.JSON, params, refund.toJSONString(), headers).assetsSuccess(true);
            JSONObject response = xmAppApi.getBodyInJSON();
            String success = response.getString("success");
            String transState = response.getJSONArray("result").getJSONObject(0).getString("transState");
            String payId = response.getJSONArray("result").getJSONObject(0).getString("id");//收款流水ID
            Assert.assertEquals(success, "true", "获取退款成功流水的查看关联交易失败");
            Assert.assertEquals(transState, "PAY_SUCCESS", "退款成功流水的查看关联交易-收款流水的状态未是收款成功");

            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }

            //收款成功流水查看关联交易
            JSONObject pay = new JSONObject();
            pay.put("id", payId);
            pay.put("brandId", xmAppApi.getLoginInfo().getBrandId());
            pay.put("studioId", xmAppApi.getLoginInfo().getStudioId());
            pay.put("operatorId", xmAppApi.getLoginInfo().getAdminId());

            xmAppApi.doRequest(RequestType.JSON, params, pay.toJSONString(), headers).assetsSuccess(true);
            JSONObject payResponse = xmAppApi.getBodyInJSON();
            String paySuccess = payResponse.getString("success");
            String payTransState = payResponse.getJSONArray("result").getJSONObject(0).getString("transState");
            String relatedRefundId = payResponse.getJSONArray("result").getJSONObject(0).getString("id");//收款流水ID
            Assert.assertEquals(paySuccess, "true", "获取收款成功流水的查看关联交易失败");
            Assert.assertEquals(payTransState, "REFUND_SUCCESS", "收款成功流水的查看关联交易-退款流水的状态未是退款成功");
            Assert.assertEquals(relatedRefundId.equals(refundId), true, "查看关联交易的退款成功流水和退款成功流水非同一个");
        }

    }
}
