package com.xiaomai.cases.polar.config;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import com.xiaomai.utils.XMBaseTest;

/**
 * @Author: xyy
 * @CreateTime: 2024-06-12  11:48
 * @Description:调起短信充值
 * @Version: 1.0
 */
public class TestSmsRecharge extends XMBaseTest {

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Config)
                .setApiName("API_smsRecharge")
                .setLoginUser(LoginAccount.XYY_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("xyy")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "调起短信充值-支付宝")
    public void testSmsRecharge_ali(){

        JSONObject object = new JSONObject();
        object.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
        object.put("paymentType","ALI");
        object.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        object.put("suitType","SUIT_ONE");

        //调用请求
        xmAppApi.doRequest(RequestType.JSON,params,object.toJSONString(),headers).assetsSuccess(true);
        JSONObject response = xmAppApi.getBodyInJSON();
        Assert.assertEquals(XMJSONPath.readPath(response,"$.message"),"操作成功!");
    }

    @Test(description = "调起短信充值-微信")
    public void testSmsRecharge_wx(){

        JSONObject object = new JSONObject();
        object.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
        object.put("paymentType","WX");
        object.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        object.put("suitType","SUIT_ONE");

        //调用请求
        xmAppApi.doRequest(RequestType.JSON,params,object.toJSONString(),headers).assetsSuccess(true);
        JSONObject response = xmAppApi.getBodyInJSON();
        Assert.assertEquals(XMJSONPath.readPath(response,"$.message"),"操作成功!");
    }
}

