package com.xiaomai.cases.polar.admin;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.util.Random;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.admin
 * @Author: xuyamei
 * @CreateTime: 2024-07-01  16:17
 * @Description: 校验场馆员工离职
 * @Version: 1.0
 */
public class TestCheckDepartStudioAdmin extends BaseTestImpl {
    @Resource(name = "adminTools")
    AdminTools adminTools;

    @BeforeClass
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_Admin,"API_checkDepartStudioAdmin", LoginAccount.XYM_PROD, Terminal.B,"xym");
        super.beforeTest();
    }

    @DataProvider
    public Object[][] dataProvider(){
        return new Object[][]{
                {true},
                {false}
        };
    }
    @Test(dataProvider = "dataProvider")
    public void checkDepartStudioAdmin(boolean isSuccess){

        if (isSuccess){
            // 查询的账号有不能离职的原因
            JSONObject response = adminTools.checkDepartStudioAdmin(xmAppApi.getLoginInfo().getAdminId());

            Assert.assertTrue(response.getJSONArray("disables").size()>0,"员工不能离职但是未返回不能离职的原因");

        }else {
            DataUserInfo dataUserInfo = new DataUserInfo();
            dataUserInfo.setLoginUser(LoginAccount.GYM_PROD2);
            // 查询的账号可以离职
            String body = "{\"size\":20,\"current\":0,\"state\":\"DUTY\"}";
            JSONObject adminPage = adminTools.pageStudioAdmin(body,dataUserInfo);
            int total = Integer.parseInt(adminPage.getJSONObject("result").getString("total"));
            if (total >0){

                int pages = Integer.parseInt(adminPage.getJSONObject("result").getString("pages"));
                // 随机获取一页
                Random rand = new Random();
                int pageIndex = rand.nextInt(pages);
                // 随机获取一页的随机员工
                Random random = new Random();
                int index = pageIndex+1 == pages ? random.nextInt(total%20-1)+1 : random.nextInt(19)+1;
                body = "{\"size\":20,\"current\":"+pageIndex+",\"state\":\"DUTY\"}";
                adminPage = adminTools.pageStudioAdmin(body,dataUserInfo);

                String adminId = adminPage.getJSONObject("result").getJSONArray("records").getJSONObject(index).getString("id");

                JSONObject response = adminTools.checkDepartStudioAdmin(adminId,dataUserInfo);
                Assert.assertTrue(response.getJSONArray("disables").size() == 0,"员工能离职但是未返回不能离职的原因");
            }

        }

    }
}
