package com.xiaomai.cases.polar.schedule.group;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.CommUtil;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 编辑当前课次/编辑当前及后续课次
 * @author adu
 * data 2024/7/2 10:45
 */

public class TestEditCurrentGroupSchedule extends UniversalDataScheduling {
    public static Date now = new Date();
    String scheduleIdsN;
    String newGroupRuldId="";


    @BeforeClass
    @Override
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Schedule, "API_editGroupSchedule", LoginAccount.ADU_PROD, Terminal.B, "adu");
        super.beforeTest();

    }

    @Test(description = "编辑当前课次")
    public void testEditCurrentGroupSchedule() {
        //获取下周四的课次ID(匹配到刚创建的规则ID)
        scheduleIdsN = groupScheduleTools.getTableDate(10,groupRuldId);
        //如果课次ID有值则继续走删除的case
        if (!StringUtils.isEmpty(scheduleIdsN)) {
                JSONObject body = new JSONObject();
                body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
                body.put("studioId", xmAppApi.getLoginInfo().getStudioId());
                body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
                body.put("applyRestRule", false);
                body.put("scheduleId", scheduleIdsN);
                //获取下周四某个时间点的开始时间戳
                String startStamp = CommUtil.getWholeHourTimeStamp(10,"13:30");
                body.put("startTime", startStamp);

                body.put("chiefCoachId", chiefCoachIdS);
                body.put("minMemberNum", 1);
                body.put("maxMemberNum", 10);
                body.put("venueAreaIds", new ArrayList<>());
                body.put("assistCoachIds", new ArrayList<>());
                body.put("spanMinutes", 50);
                body.put("force", true);//有冲突时忽略冲突
                body.put("retainBooking", false);//不保留学员预约

                xmAppApi.doRequest(RequestType.JSON, params, body.toString(), headers);
                Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(xmAppApi.getApi_response(),"$.success"))==true,"调用接口返回结果："+XMJSONPath.readPath(xmAppApi.getApi_response(),"$.message"));

            try {
                    Thread.sleep(1000);
                } catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                //编辑成功后check对应课次详情修改内容是否同步成功
                groupScheduleTools.getScheduleItemDetail(scheduleIdsN);
                String detailResult = dataApi.getApi_response();
                Assert.assertEquals(XMJSONPath.readPath(detailResult, "$.result.chiefCoachId"), chiefCoachIdS);
                Assert.assertEquals(XMJSONPath.readPath(detailResult, "$.result.minMemberNum"), "1");
                Assert.assertEquals(XMJSONPath.readPath(detailResult, "$.result.maxMemberNum"), "10");
                Assert.assertEquals(XMJSONPath.readPath(detailResult, "$.result.startTime"), startStamp);
                Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(detailResult, "$.result.assistCoachIds").size() == 0, "助教修改后（置空）没生效");
                Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(detailResult, "$.result.venueAreaIds").size() == 0, "场地修改后（置空）没生效");


        }

    }




        @Test(description = "删除此case创建的日程",priority = 1)
        public void delData () {

            if (!StringUtils.isEmpty(groupRuldId)) {//获取到的日程ID不为空时，则逐个删除相关日程
                    //删除对应日程
                    groupScheduleTools.delGroupRuleSchedule(groupRuldId, true);
            }

            if (!scheduleIdsN.isEmpty()) {
                //删除case1中编辑独立出去的课次
                groupScheduleTools.delGroupScheduleItem(scheduleIdsN);
            }


        }
    }




    