package com.xiaomai.cases.polar.clue;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @Author zxy
 * @Description
 * @Date 2024/6/30 16:31
 */
public class TestBatchUpdateSaleRule extends XMBaseTest {
    MemberTools memberTools = new MemberTools();
    @BeforeMethod
    public void beforeTest(){

        xmAppApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_batchUpdateSaleRule")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("zyx")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "更新销售规则-关闭公有池开关")
    public void testBatchUpdateSaleRule(){
        JSONObject configs = new JSONObject();
        configs.put("CRM_OPEN_PUBLIC_RESOURCE_POOL",false);
        configs.put("CRM_SALE_RELEASE_CLUE_DESTINATION","ALL_CLUE");
        configs.put("CRM_SYS_RELEASE_CLUE_DESTINATION","ALL_CLUE");

        JSONObject object = new JSONObject();
        object.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        object.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        object.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
        object.put("configs",configs);

        xmAppApi.doRequest(RequestType.JSON,params,object.toString(),headers).assetsSuccess(true);
        Assert.assertEquals(memberTools.fetchCrmContext().getJSONObject("result").getString("openPublicResource"),"false");
    }

    @Test(description = "更新销售规则-开启公有池开关")
    public void testBatchUpdateSaleRule_1(){
        JSONObject configs = new JSONObject();
        configs.put("CRM_OPEN_PUBLIC_RESOURCE_POOL",true);
        configs.put("CRM_SALE_RELEASE_CLUE_DESTINATION","ALL_CLUE");
        configs.put("CRM_SYS_RELEASE_CLUE_DESTINATION","PUBLIC_RESOURCE");

        JSONObject object = new JSONObject();
        object.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        object.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        object.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
        object.put("configs",configs);

        xmAppApi.doRequest(RequestType.JSON,params,object.toString(),headers).assetsSuccess(true);
        Assert.assertEquals(memberTools.fetchCrmContext().getJSONObject("result").getString("openPublicResource"),"true");
    }
}
