package com.xiaomai.cases.polar.goods.Tools;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;

import java.math.BigDecimal;

public class GoodTools extends XMBaseTest {
//
//    /**
//     * @param
//     * @description:新建物品
//     * @param multiSpec:是否是多规格；true：多规格；false：单规格
//     * @author: yff
//     **/
//
//    public JSONObject testCreateGoods(boolean multiSpec,DataUserInfo...userInfos) {
//        dataApi.setApiModule(ApiModule.Polar_Goods)
//                .setApiName("API_createGoods")
//                .setTerminal(Terminal.B);
//
//        super.beforeDataRequest(userInfos);
//
//        String color1 = "黑色";
//        String color2 = "白色";
//        String size1 = "大的";
//        String size2 = "小的";
//        String skin1 = "貂蝉";
//        String skin2 = "王昭君";
//
//        JSONObject jsonObject = new JSONObject();
//
//        //多规格
//        if (multiSpec==true) {
//
//            //商品介绍不为空，纯文本的写法
//            JSONObject description = new JSONObject();
//            JSONArray items = new JSONArray();
//            JSONObject item1 = new JSONObject();
//            item1.put("type", "TEXT");
//            item1.put("content", "自动化创建的多规格三个规格，每个规格都有两个规格值");
//            item1.put("aspect", "");
//
//            items.add(item1);
//
//            description.put("items", items);
//            jsonObject.put("description", description.toString());
//
//
//            jsonObject.put("groupId", "1873903328974499841");
//            jsonObject.put("multiSpec", true);
//            jsonObject.put("name", "自动化创建三个规格" + RandomStringUtil.randomString(2));
//            jsonObject.put("xcxSaleState", "YES");
//
//
//            JSONObject multiSpecInfo = new JSONObject();
//
//            //设置三个规格和每个都有两个规格值
//            JSONArray specList = new JSONArray();
//            JSONObject specList1 = new JSONObject();
//            specList1.put("name", "颜色");
//
//            JSONArray specList1SpecValues = new JSONArray();
//            JSONObject specList1SpecValues1 = new JSONObject();
//            specList1SpecValues1.put("name", color1);
//            JSONObject specList1SpecValues2 = new JSONObject();
//            specList1SpecValues2.put("name", color2);
//            specList1SpecValues.add(specList1SpecValues1);
//            specList1SpecValues.add(specList1SpecValues2);
//            specList1.put("specValues", specList1SpecValues);
//
//            JSONObject specList2 = new JSONObject();
//            specList2.put("name", "尺码");
//
//            JSONArray specList2SpecValues = new JSONArray();
//            JSONObject specList2SpecValues1 = new JSONObject();
//            specList2SpecValues1.put("name", size1);
//            JSONObject specList2SpecValues2 = new JSONObject();
//            specList2SpecValues2.put("name", size2);
//            specList2SpecValues.add(specList2SpecValues1);
//            specList2SpecValues.add(specList2SpecValues2);
//            specList2.put("specValues", specList2SpecValues);
//
//
//            JSONObject specList3 = new JSONObject();
//            specList3.put("name", "限定皮肤");
//
//            JSONArray specList3SpecValues = new JSONArray();
//            JSONObject specList3SpecValues1 = new JSONObject();
//            specList3SpecValues1.put("name", skin1);
//            JSONObject specList3SpecValues2 = new JSONObject();
//            specList3SpecValues2.put("name", skin2);
//            specList3SpecValues.add(specList3SpecValues1);
//            specList3SpecValues.add(specList3SpecValues2);
//            specList3.put("specValues", specList3SpecValues);
//
//            specList.add(specList1);
//            specList.add(specList2);
//            specList.add(specList3);
//
//            multiSpecInfo.put("specList", specList);
//
//
//            try {
//                Thread.sleep(3000);
//            } catch (InterruptedException e) {
//                throw new RuntimeException(e);
//            }
//
//            //排列出来的组合2*2*2
//            JSONArray specCombinationList = new JSONArray();
//
//            JSONObject specCombinationList1 = new JSONObject();
//
//            JSONArray specCombinationList1Specs = new JSONArray();
//            specCombinationList1Specs.add(color1);
//            specCombinationList1Specs.add(size1);
//            specCombinationList1Specs.add(skin1);
//            specCombinationList1.put("specs", specCombinationList1Specs);
//            specCombinationList1.put("price", "0.01");
//            specCombinationList1.put("inventory", 10);
//
//            specCombinationList.add(specCombinationList1);
//
//            JSONObject specCombinationList2 = new JSONObject();
//            JSONArray specCombinationList2Specs = new JSONArray();
//            specCombinationList2Specs.add(color1);
//            specCombinationList2Specs.add(size1);
//            specCombinationList2Specs.add(skin2);
//            specCombinationList2.put("specs", specCombinationList2Specs);
//            specCombinationList2.put("price", "0.01");
//            specCombinationList2.put("inventory", 10);
//
//            specCombinationList.add(specCombinationList2);
//
//
//            JSONObject specCombinationList3 = new JSONObject();
//            JSONArray specCombinationList3Specs = new JSONArray();
//            specCombinationList3Specs.add(color1);
//            specCombinationList3Specs.add(size2);
//            specCombinationList3Specs.add(skin1);
//            specCombinationList3.put("specs", specCombinationList3Specs);
//            specCombinationList3.put("price", "0.01");
//            specCombinationList3.put("inventory", 10);
//
//            specCombinationList.add(specCombinationList3);
//
//
//            JSONObject specCombinationList4 = new JSONObject();
//            JSONArray specCombinationList4Specs = new JSONArray();
//            specCombinationList4Specs.add(color1);
//            specCombinationList4Specs.add(size2);
//            specCombinationList4Specs.add(skin2);
//            specCombinationList4.put("specs", specCombinationList4Specs);
//            specCombinationList4.put("price", "0.01");
//            specCombinationList4.put("inventory", 10);
//
//            specCombinationList.add(specCombinationList4);
//
//
//            JSONObject specCombinationList5 = new JSONObject();
//            JSONArray specCombinationList5Specs = new JSONArray();
//            specCombinationList5Specs.add(color2);
//            specCombinationList5Specs.add(size1);
//            specCombinationList5Specs.add(skin1);
//            specCombinationList5.put("specs", specCombinationList5Specs);
//            specCombinationList5.put("price", "0.01");
//            specCombinationList5.put("inventory", 10);
//
//            specCombinationList.add(specCombinationList5);
//
//
//            JSONObject specCombinationList6 = new JSONObject();
//            JSONArray specCombinationList6Specs = new JSONArray();
//            specCombinationList6Specs.add(color2);
//            specCombinationList6Specs.add(size1);
//            specCombinationList6Specs.add(skin2);
//            specCombinationList6.put("specs", specCombinationList6Specs);
//            specCombinationList6.put("price", "0.01");
//            specCombinationList6.put("inventory", 10);
//
//            specCombinationList.add(specCombinationList6);
//
//            JSONObject specCombinationList7 = new JSONObject();
//            JSONArray specCombinationList7Specs = new JSONArray();
//            specCombinationList7Specs.add(color2);
//            specCombinationList7Specs.add(size2);
//            specCombinationList7Specs.add(skin1);
//            specCombinationList7.put("specs", specCombinationList7Specs);
//            specCombinationList7.put("price", "0.01");
//            specCombinationList7.put("inventory", 10);
//
//            specCombinationList.add(specCombinationList7);
//
//
//            JSONObject specCombinationList8 = new JSONObject();
//            JSONArray specCombinationList8Specs = new JSONArray();
//            specCombinationList8Specs.add(color2);
//            specCombinationList8Specs.add(size2);
//            specCombinationList8Specs.add(skin2);
//            specCombinationList8.put("specs", specCombinationList8Specs);
//            specCombinationList8.put("price", "0.01");
//            specCombinationList8.put("inventory", 10);
//
//            specCombinationList.add(specCombinationList8);
//
//            multiSpecInfo.put("specCombinationList", specCombinationList);
//            jsonObject.put("multiSpecInfo", multiSpecInfo);
//            jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
//            jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
//            jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());
//        }
//
//        //单规格
//        else if (multiSpec==false){
//
//                //商品介绍不为空，纯文本的写法
//                JSONObject description = new JSONObject();
//                JSONArray items = new JSONArray();
//                JSONObject item1 = new JSONObject();
//                item1.put("type", "TEXT");
//                item1.put("content", "自动化创建的");
//                item1.put("aspect", "");
//
//                items.add(item1);
//
//                description.put("items", items);
//                jsonObject.put("description", description.toString());
//
//                jsonObject.put("groupId", "1873903328974499841");
//                jsonObject.put("multiSpec", false);
//                jsonObject.put("name", "自动化创建单规格" + RandomStringUtil.randomString(2));
//                jsonObject.put("xcxSaleState", "YES");
//                JSONObject jsonObject2 = new JSONObject();
//
//                jsonObject2.put("inventory", "10");
//                jsonObject2.put("price", "0.01");
//
//                jsonObject.put("singleSpecInfo", jsonObject2);
//                jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
//                jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
//                jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());
//
//        }
//
//        dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toString(),dataheadrs).assetsSuccess(true);
//        return dataApi.getBodyInJSON();
//
//    }

    /**
     * @param
     * @description:新建物品_多规格(三个规格，每个规格都是三个规格值)
     * @param xcxSaleState:是否开启小程序售卖  YES：开启   NO：关闭；
     * @param price：每个sku的售价
     * @param inventory 库存
     * @author: yff
     **/
    public JSONObject createGoods_multiple(String xcxSaleState, String price,int inventory,DataUserInfo...userInfos) {
        dataApi.setApiModule(ApiModule.Polar_Goods)
                .setApiName("API_createGoods")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);


        // 存量的分组："id": "1873912725360504834","name": "自动化分组多规格",因为分组不能超过10个，所以很多地方用存量就够了

        String color1 = "黑色";
        String color2 = "白色";
        String size1 = "大的";
        String size2 = "小的";
        String skin1 = "貂蝉";
        String skin2 = "王昭君";

        JSONObject jsonObject = new JSONObject();


            //商品介绍不为空，纯文本的写法
            JSONObject description = new JSONObject();
            JSONArray items = new JSONArray();
            JSONObject item1 = new JSONObject();
            item1.put("type", "TEXT");
            item1.put("content", "自动化创建的多规格三个规格，每个规格都有两个规格值");
            item1.put("aspect", "");

            items.add(item1);

            description.put("items", items);
            jsonObject.put("description", description.toString());


            jsonObject.put("groupId", "1873912725360504834");
            jsonObject.put("multiSpec", true);
            jsonObject.put("name", "自动化创建三规格" + RandomStringUtil.randomString(6));
            jsonObject.put("xcxSaleState",xcxSaleState);


            JSONObject multiSpecInfo = new JSONObject();

            //设置三个规格和每个都有两个规格值
            JSONArray specList = new JSONArray();
            JSONObject specList1 = new JSONObject();
            specList1.put("name", "颜色");

            JSONArray specList1SpecValues = new JSONArray();
            JSONObject specList1SpecValues1 = new JSONObject();
            specList1SpecValues1.put("name", color1);
            JSONObject specList1SpecValues2 = new JSONObject();
            specList1SpecValues2.put("name", color2);
            specList1SpecValues.add(specList1SpecValues1);
            specList1SpecValues.add(specList1SpecValues2);
            specList1.put("specValues", specList1SpecValues);

            JSONObject specList2 = new JSONObject();
            specList2.put("name", "尺码");

            JSONArray specList2SpecValues = new JSONArray();
            JSONObject specList2SpecValues1 = new JSONObject();
            specList2SpecValues1.put("name", size1);
            JSONObject specList2SpecValues2 = new JSONObject();
            specList2SpecValues2.put("name", size2);
            specList2SpecValues.add(specList2SpecValues1);
            specList2SpecValues.add(specList2SpecValues2);
            specList2.put("specValues", specList2SpecValues);


            JSONObject specList3 = new JSONObject();
            specList3.put("name", "限定皮肤");

            JSONArray specList3SpecValues = new JSONArray();
            JSONObject specList3SpecValues1 = new JSONObject();
            specList3SpecValues1.put("name", skin1);
            JSONObject specList3SpecValues2 = new JSONObject();
            specList3SpecValues2.put("name", skin2);
            specList3SpecValues.add(specList3SpecValues1);
            specList3SpecValues.add(specList3SpecValues2);
            specList3.put("specValues", specList3SpecValues);

            specList.add(specList1);
            specList.add(specList2);
            specList.add(specList3);

            multiSpecInfo.put("specList", specList);


            try {
                Thread.sleep(3000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }

            //排列出来的组合2*2*2
            JSONArray specCombinationList = new JSONArray();

            JSONObject specCombinationList1 = new JSONObject();

            JSONArray specCombinationList1Specs = new JSONArray();
            specCombinationList1Specs.add(color1);
            specCombinationList1Specs.add(size1);
            specCombinationList1Specs.add(skin1);
            specCombinationList1.put("specs", specCombinationList1Specs);
            specCombinationList1.put("price", price);
            specCombinationList1.put("inventory", inventory);

            specCombinationList.add(specCombinationList1);

            JSONObject specCombinationList2 = new JSONObject();
            JSONArray specCombinationList2Specs = new JSONArray();
            specCombinationList2Specs.add(color1);
            specCombinationList2Specs.add(size1);
            specCombinationList2Specs.add(skin2);
            specCombinationList2.put("specs", specCombinationList2Specs);
            specCombinationList2.put("price", price);
            specCombinationList2.put("inventory", inventory);

            specCombinationList.add(specCombinationList2);


            JSONObject specCombinationList3 = new JSONObject();
            JSONArray specCombinationList3Specs = new JSONArray();
            specCombinationList3Specs.add(color1);
            specCombinationList3Specs.add(size2);
            specCombinationList3Specs.add(skin1);
            specCombinationList3.put("specs", specCombinationList3Specs);
            specCombinationList3.put("price", price);
            specCombinationList3.put("inventory", inventory);

            specCombinationList.add(specCombinationList3);


            JSONObject specCombinationList4 = new JSONObject();
            JSONArray specCombinationList4Specs = new JSONArray();
            specCombinationList4Specs.add(color1);
            specCombinationList4Specs.add(size2);
            specCombinationList4Specs.add(skin2);
            specCombinationList4.put("specs", specCombinationList4Specs);
            specCombinationList4.put("price", price);
            specCombinationList4.put("inventory", inventory);

            specCombinationList.add(specCombinationList4);


            JSONObject specCombinationList5 = new JSONObject();
            JSONArray specCombinationList5Specs = new JSONArray();
            specCombinationList5Specs.add(color2);
            specCombinationList5Specs.add(size1);
            specCombinationList5Specs.add(skin1);
            specCombinationList5.put("specs", specCombinationList5Specs);
            specCombinationList5.put("price", price);
            specCombinationList5.put("inventory",inventory);

            specCombinationList.add(specCombinationList5);


            JSONObject specCombinationList6 = new JSONObject();
            JSONArray specCombinationList6Specs = new JSONArray();
            specCombinationList6Specs.add(color2);
            specCombinationList6Specs.add(size1);
            specCombinationList6Specs.add(skin2);
            specCombinationList6.put("specs", specCombinationList6Specs);
            specCombinationList6.put("price",price);
            specCombinationList6.put("inventory",inventory);

            specCombinationList.add(specCombinationList6);

            JSONObject specCombinationList7 = new JSONObject();
            JSONArray specCombinationList7Specs = new JSONArray();
            specCombinationList7Specs.add(color2);
            specCombinationList7Specs.add(size2);
            specCombinationList7Specs.add(skin1);
            specCombinationList7.put("specs", specCombinationList7Specs);
            specCombinationList7.put("price", price);
            specCombinationList7.put("inventory", inventory);

            specCombinationList.add(specCombinationList7);


            JSONObject specCombinationList8 = new JSONObject();
            JSONArray specCombinationList8Specs = new JSONArray();
            specCombinationList8Specs.add(color2);
            specCombinationList8Specs.add(size2);
            specCombinationList8Specs.add(skin2);
            specCombinationList8.put("specs", specCombinationList8Specs);
            specCombinationList8.put("price", price);
            specCombinationList8.put("inventory", inventory);

            specCombinationList.add(specCombinationList8);

            multiSpecInfo.put("specCombinationList", specCombinationList);
            jsonObject.put("multiSpecInfo", multiSpecInfo);
            jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
            jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
            jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

            dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toString(),dataheadrs).assetsSuccess(true);
            return dataApi.getBodyInJSON();
        }

    /**
     * @param
     * @description:新建物品_单规格
     * @param xcxSaleState:是否开启小程序售卖  YES：开启   NO：关闭
     * @param price：每个规格值的售价
     * @param inventory 库存
     * @author: yff
     **/
    public JSONObject createGoods_single(String xcxSaleState, String price,int inventory,DataUserInfo...userInfos) {
        dataApi.setApiModule(ApiModule.Polar_Goods)
                .setApiName("API_createGoods")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        // 存量的分组：	"id": "1873903328974499841","name": "自动化分组单规格",因为分组不能超过10个，所以很多地方用存量就够了


        JSONObject jsonObject = new JSONObject();

            //商品介绍不为空，纯文本的写法
            JSONObject description = new JSONObject();
            JSONArray items = new JSONArray();
            JSONObject item1 = new JSONObject();
            item1.put("type", "TEXT");
            item1.put("content", "自动化创建的单规格");
            item1.put("aspect", "");

            items.add(item1);

            description.put("items", items);
            jsonObject.put("description", description.toString());

            jsonObject.put("groupId", "1873903328974499841");
            jsonObject.put("multiSpec", false);
            jsonObject.put("name", "自动化创建单规格" + RandomStringUtil.randomString(6));
            jsonObject.put("xcxSaleState",xcxSaleState);
            JSONObject jsonObject2 = new JSONObject();

            jsonObject2.put("inventory",inventory);
            jsonObject2.put("price",price);

            jsonObject.put("singleSpecInfo", jsonObject2);
            jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
            jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
            jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

            dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toString(),dataheadrs).assetsSuccess(true);
            return dataApi.getBodyInJSON();

    }

    /**
     * @param
     * @description:获取物品列表
     * @author: yff
     **/

    public JSONObject studioGoods( String nameLike,DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Goods)
                .setApiName("API_pageStudioGoods")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject jsonObject = new JSONObject();

        jsonObject.put("current", 0);
        jsonObject.put("size", 20);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * @param
     * @description:删除物品
     * @author: yff
     **/

    public JSONObject deleteGoods(String id, DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Goods)
                .setApiName("API_delete")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject jsonObject = new JSONObject();

        jsonObject.put("id", id);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * @param
     * @description:新建物品的重名校验
     * @param name：物品名称
     * @author: yff
     **/

    public JSONObject checkRepeatNameForStudio(String name, DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Goods)
                .setApiName("API_checkRepeatNameForStudio")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject jsonObject = new JSONObject();

        jsonObject.put("name", name);
        jsonObject.put("id","");
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }


    /**
     * @param
     * @description:获取B端的物品详情
     * @param id：物品ID
     * @author: yff
     **/

    public JSONObject getDetail_goods(String id, DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Goods)
                .setApiName("API_getDetail_goods")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject jsonObject = new JSONObject();

        jsonObject.put("id",id);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * @param
     * @description:获取多规格物品的库存详情；注意仅多规格，单规格没有这个接口
     * @param id：物品ID
     * @author: yff
     **/

    public JSONObject listMultiSpecInventorRecords(String id, DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Goods)
                .setApiName("API_listMultiSpecInventorRecords")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject jsonObject = new JSONObject();

        jsonObject.put("id",id);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }


    /**
     * @param
     * @description:新建分組
     * @param name：分組名称
     * @author: yff
     **/

    public JSONObject createGoodsGroup(String name, DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Goods)
                .setApiName("API_createGoodsGroup")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject jsonObject = new JSONObject();

        jsonObject.put("name",name);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * @param
     * @description:获取分组列表
     * @author: yff
     **/

    public JSONObject listPageGoodsGroup( DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Goods)
                .setApiName("API_listPageGoodsGroup")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject jsonObject = new JSONObject();

        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * @param
     * @description:分组重名校验
     * @author: yff
     **/

    public JSONObject checkNameRepeatGoodsGroup(String name, DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Goods)
                .setApiName("API_checkNameRepeatGoodsGroup")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject jsonObject = new JSONObject();

        jsonObject.put("name",name);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }


    /**
     * @param
     * @description:删除分组
     * @param id：分组ID
     * @author: yff
     **/

    public JSONObject deleteGoodsGroup(String id, DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Goods)
                .setApiName("API_deleteGoodsGroup")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject jsonObject = new JSONObject();

        jsonObject.put("id",id);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * @param
     * @description:删除分组前是否存在物品的校验
     * @param id：分组ID
     * @author: yff
     **/

    public JSONObject checkAllowDelete(String id, DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Goods)
                .setApiName("API_checkAllowDelete")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject jsonObject = new JSONObject();

        jsonObject.put("id",id);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * @param
     * @description:编辑分组
     * @param id：分组ID
     * @param name：修改后的分组名称
     * @author: yff
     **/

    public JSONObject modifyGoodsGroup(String id,String name, DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Goods)
                .setApiName("API_modifyGoodsGroup")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject jsonObject = new JSONObject();

        jsonObject.put("id",id);
        jsonObject.put("name",name);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * @param
     * @description:新建物品时拉取物品分组
     * @author: yff
     **/

    public JSONObject listGoodsGroup(DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Goods)
                .setApiName("API_listGoodsGroup")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * @param
     * @description:批量修改物品的分组
     * @param groupId：分组ID
     * @param id：物品ID
     * @author: yff
     **/

    public JSONObject batchModifyGoodsBelongGroup(String groupId,String id,DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Goods)
                .setApiName("API_batchModifyGoodsBelongGroup")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("groupId",groupId);

        JSONArray ids=new JSONArray();
        ids.add(id);
        jsonObject.put("ids",ids);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * @param
     * @description:B端修改物品的小程序售卖是否开启
     * @param id：物品ID
     * @param xcxSaleState：小程序是否开启   YES开启小程序售卖  NO关闭小程序售卖
     * @author: yff
     **/

    public JSONObject modifyGoodsXcxSaleState(String id,String xcxSaleState,DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Goods)
                .setApiName("API_modifyGoodsXcxSaleState")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id",id);
        jsonObject.put("xcxSaleState",xcxSaleState);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }


    /**
     * @param
     * @description:B端修改物品状态是否为开启
     * @param id：物品ID
     * @param state：物品状态   YES启用  NO停用
     * @author: yff
     **/

    public JSONObject modifyGoodsState(String id,String state,DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Goods)
                .setApiName("API_modifyGoodsState")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id",id);
        jsonObject.put("state",state);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * @param
     * @description:查看物品的编辑记录
     * @param goodsId：物品ID
     * @author: yff
     **/

    public JSONObject pageGoodsModifyRecord(String goodsId,DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Goods)
                .setApiName("API_pageGoodsModifyRecord")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("goodsId",goodsId);
        jsonObject.put("current",0);
        jsonObject.put("size",20);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * @param
     * @description:B端退单时拉取可退物品
     * @param receiverId：会员ID
     * @author: yff
     **/

    public JSONObject listLeftGoodsItem(String receiverId,DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Goods)
                .setApiName("API_listLeftGoodsItem")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("receiverId",receiverId);
        jsonObject.put("content","");
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }


    /**
     * @param
     * @description:B端退单时获取订单可退物品（退单界面）
     * @param id：	是listLeftGoodsItem拉取可退的物品列表接口中："result":{ [{"id": "1874695209647783938",}]}
     * @author: yff
     **/

    public JSONObject getLeftGoodsItem(String id,DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Goods)
                .setApiName("API_getLeftGoodsItem")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id",id);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }


    /**
     * @param
     * @description:B端退单物品
     * @param  quantity:退出数量
     * @param  refundAmount:退出金额
     * @param  refundInventory:退货退款：true 仅退款：false
     * @param  voucherItemId：是listLeftGoodsItem拉取可退的物品列表接口中："result":{ [{"id": "1874695209647783938",}]}
     * @param  memberId:会员ID
     * @param  receivableAmount:应退金额
     * @param  amount:支付金额
     * @param  paymentWay:支付方式  1 2 ...
     * @param  depositRechargeAmount：退回储值卡充值金额  没有的话就是new BigDecimal("0.00")
     * @param  depositGiveAmount：退回储值卡赠送金额  没有的话就是new BigDecimal("0.00")
     * @param  depositCardId：退回储值卡 没有的话就是""
     * @author: yff
     **/

    public JSONObject refundGoods(String ownerId,String ownerName,int quantity, BigDecimal refundAmount,boolean refundInventory,String voucherItemId,String memberId,BigDecimal receivableAmount,
                                  BigDecimal amount,String paymentWay,BigDecimal depositRechargeAmount,BigDecimal depositGiveAmount,String depositCardId,
                                  int fee,BigDecimal refundableAmount,BigDecimal refundAmount_actual,DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Goods)
                .setApiName("API_refundGoods")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject refundGoods=new JSONObject();
        refundGoods.put("operationTime", TimeUtils.getTodayTime());

        JSONArray businessOwners=new JSONArray();
        JSONObject businessOwners1=new JSONObject();
        businessOwners1.put("ownerId",ownerId);
        businessOwners1.put("ownerName",ownerName);
        businessOwners1.put("percent",100);
        businessOwners.add(businessOwners1);
        refundGoods.put("businessOwners",businessOwners);

        JSONObject goods=new JSONObject();
        goods.put("quantity",quantity);
        goods.put("refundAmount",refundAmount);
        goods.put("refundInventory",refundInventory);
        goods.put("voucherItemId",voucherItemId);

        refundGoods.put("goods",goods);
        refundGoods.put("objectId", RandomStringUtil.randomString(32));
        refundGoods.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        refundGoods.put("memberId",memberId);
        refundGoods.put("receivableAmount",receivableAmount);
        refundGoods.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
        JSONArray paymentWays=new JSONArray();
        JSONObject object=new JSONObject();
        object.put("amount",amount);
        object.put("paymentWay",paymentWay);
        JSONArray voucherResourceIds=new JSONArray();
        object.put("voucherResourceIds",voucherResourceIds);
        paymentWays.add(object);
        refundGoods.put("paymentWays",paymentWays);
        refundGoods.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        refundGoods.put("depositRechargeAmount",depositRechargeAmount);
        refundGoods.put("depositGiveAmount",depositGiveAmount);
        refundGoods.put("depositCardId",depositCardId);
        refundGoods.put("fee",fee);
        refundGoods.put("refundableAmount",refundableAmount);
        refundGoods.put("refundAmount",refundAmount_actual);


        dataApi.doRequest(RequestType.JSON,dataparams,refundGoods.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }


    /**
     * @param
     * @description:获取规格名/规格值修改后的物品规格列表(这里是修改为1个规格，两个规格值)
     * @param id:物品ID
     * @param specListObjectId:第一个规格的规格ID
     * @param specListObjectName:第一个规格的规格名称
     * @param specValuesObject1Id：第一个规格值的规格值ID
     * @param specValuesObject1Name:第一个规格值的规格值名称
     * @param specValuesObject2Id：第二个规格值的规格值ID
     * @param specValuesObject2Name：第二个规格值的规格值名称
     * @author: yff
     **/

    public JSONObject listModifiedSpecCombinations(String id,String specListObjectId, String specListObjectName,String specValuesObject1Id,String specValuesObject1Name,
                                                   String specValuesObject2Id,String specValuesObject2Name,DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Goods)
                .setApiName("API_listModifiedSpecCombinations")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject listModifiedSpecCombinations=new JSONObject();
        listModifiedSpecCombinations.put("id", id);

        JSONArray specList=new JSONArray();
        JSONObject specListObject=new JSONObject();
        specListObject.put("id",specListObjectId);
        specListObject.put("name",specListObjectName);

        JSONArray specValues=new JSONArray();
        JSONObject specValuesObject1=new JSONObject();
        specValuesObject1.put("id",specValuesObject1Id);
        specValuesObject1.put("name",specValuesObject1Name);

        JSONObject specValuesObject2=new JSONObject();
        specValuesObject2.put("id",specValuesObject2Id);
        specValuesObject2.put("name",specValuesObject2Name);

        specValues.add(specValuesObject1);
        specValues.add(specValuesObject2);
        specListObject.put("specValues",specValues);
        specList.add(specListObject);

        listModifiedSpecCombinations.put("specList",specList);

        listModifiedSpecCombinations.put("brandId", dataApi.getLoginInfo().getBrandId());
        listModifiedSpecCombinations.put("studioId", dataApi.getLoginInfo().getStudioId());
        listModifiedSpecCombinations.put("operatorId",dataApi.getLoginInfo().getAdminId());


        dataApi.doRequest(RequestType.JSON,dataparams,listModifiedSpecCombinations.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }




}
