package com.xiaomai.cases.lunar.order;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.lunar.minMemberCard.MinCardTools;
import com.xiaomai.cases.lunar.user.UserTools;
import com.xiaomai.cases.polar.finance.order.OrderTools;
import com.xiaomai.cases.polar.memberCard.CardTools;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;

public class TestPurchaseDeposit extends XMBaseTest {
    @Resource(name = "userTools")
    UserTools userTools;
    @Resource(name = "minCardTools")
    MinCardTools minCardTools;
    @Resource(name = "cardTools")
    CardTools cardTools;
    @Resource(name = "orderCTools")
    OrderCTools orderCTools;
    @Resource(name = "orderTools")
    OrderTools orderTools;
    DataUserInfo info = new DataUserInfo();

    public String memberId;
    public String cardId;
    public String cardName;
    public String orderId;

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Lunar_Order)
                .setApiName("API_purchaseDeposit")
                .setLoginUser(LoginAccount.GYM_MINIAPPC)
                .setTerminal(Terminal.minApp);

        dal.setCase_owner("xyy")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @Test(description = "C端购买储值卡")
    public void testPurchaseDeposit() throws InterruptedException {

        info.setTerminal(Terminal.B);
        info.setLoginUser(LoginAccount.GYM_PROD);

        //搜索0元储值卡
        int num = XMJSONPath.getJSONArrayByReadPath(cardTools.tenantMemberCardCommonSearch("DEPOSIT_CARD","0元储值卡",info), "$.result").size();
        //如果没有0元储值卡创建1张
        if (num==0){
            cardTools.depositCardCreate("0元储值卡" + RandomStringUtil.randomString(4),"0.00","100.00",info);
        }
        //获取会员信息
        memberId = userTools.getMemberInfo().getString("memberId");
        //查询会员名下的卡包数量
        int cardNum = minCardTools.countMyUsableCard(memberId);
        //获取1张0元储值卡id
        cardId = minCardTools.fetchOnSaleMemberCard("0元储值卡","DEPOSIT_CARD").getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");
        cardName = minCardTools.fetchOnSaleMemberCard("0元储值卡","DEPOSIT_CARD").getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("title");
        //确认订单页
        orderCTools.findTenantCardDetailById(cardId,null);

        //构建提交订单的参数
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("activatePattern","PURCHASE");
        jsonObject.put("cardId",cardId);
        jsonObject.put("cardSnapshotId",cardId);
        jsonObject.put("memberId",memberId);
        jsonObject.put("memo","自动化C端购买储值卡");
        jsonObject.put("receivableAmount","0.00");
        jsonObject.put("commodityCardType","DEPOSIT_CARD");
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("objectId",RandomStringUtil.randomString(16));

        //调用详情
        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);
        //获取返回值里的订单id
        orderId = XMJSONPath.readPath(xmAppApi.getBodyInJSON(), "$.result");
        //check该订单的状态及名称
        Assert.assertEquals(XMJSONPath.readPath(orderCTools.getDetail(orderId),"$.result.state"),"PAID");
        Assert.assertEquals(XMJSONPath.readPath(orderCTools.getDetail(orderId),"$.result.voucherItems[0].purchaseDepositSkuAttr.skuName"),cardName);
        String skuId = XMJSONPath.readPath(orderCTools.getDetail(orderId),"$.result.voucherItems[0].skuId");

        //check我的卡包数据+1
        Thread.sleep(1000);
        Assert.assertTrue(minCardTools.countMyUsableCard(memberId) == cardNum + 1);
        //check我的卡包里有该生效中的卡
        Thread.sleep(1000);
        JSONObject object = minCardTools.getMyMemberCardList(true,memberId,"DEPOSIT");
        Assert.assertEquals(XMJSONPath.readPath(object,"$.result[0].tenantMemberCardId"),skuId);
    }

    @Test(description = "数据清理",priority = 1)
    public void clearData(){
        info.setTerminal(Terminal.B);
        info.setLoginUser(LoginAccount.GYM_PROD);

        //作废订单
        orderTools.discard(orderId,"其他","自动化作废订单",info);
        //check储值卡状态为已作废
        Assert.assertEquals(XMJSONPath.readPath(cardTools.memberCardFindDetailById(cardId,info),"$.result.state"),"DISCARD");
        //check剩余金额=0
        Assert.assertEquals(XMJSONPath.readPath(cardTools.memberCardFindDetailById(cardId,info),"$.result.leftBalance"),"0.00");
        //check消耗记录有1条作废订单记录
        String benefitId = XMJSONPath.readPath(cardTools.memberCardFindDetailById(cardId,info),"$.result.depositBenefit.id");
        Assert.assertEquals(XMJSONPath.readPath(cardTools.fetchPageOfConsumeRecord(benefitId,cardId,info),"$.result.records[0].consumeType").equals("DISCARD_ORDER"),"作废订单，消耗记录第一条操作类型");
    }

}
