package com.xiaomai.cases.polar.schedule.group;

import com.alibaba.fastjson.JSONArray;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.polar.course.CourseTools;
import com.xiaomai.cases.polar.setting.courseCategory.CourseCategoryTools;
import com.xiaomai.cases.polar.setting.venue.VenueAreaTools;
import com.xiaomai.cases.polar.studioConfig.HomeTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.CommUtil;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * 创建排课
 * @author adu
 * data 2024/6/12 15:54
 */

public class TestCreateGroupRuleSchedule extends BaseTestImpl {
    @Resource(name = "courseCategoryTools")
    CourseCategoryTools courseCategoryTools;
    @Resource(name = "courseTools")
    CourseTools courseTools;
    @Resource(name = "groupScheduleTools")
    GroupScheduleTools groupScheduleTools;
    @Resource(name = "venueAreaTools")
    VenueAreaTools venueAreaTools;

    //获取本周第一天的时间戳
    String beginTimeTamp = CommUtil.oneKeyGetWeekStartDay();
    //获取当前时间加160天后的时间戳 23:59:59 用于结束日期
    String endDateTimeTamp = CommUtil.getNDayEndTimeTamp(180);
    //获取当天时间时间戳:当天时间戳格式：2024-6-12 00：00：00点，用于开始日期
    String todayStartTimeTamp = CommUtil.oneKeyGetAddDay(0);

    //获取今天结束日期的时间戳
    String todayEndDateTimeTamp = CommUtil.getNDayEndTimeTamp(0);
    String courseName = "阿杜自动化团课课程";

    @BeforeClass
    @Override
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Schedule, "API_createGroupRuleSchedule", LoginAccount.ADU_PROD, Terminal.B, "adu");
        super.beforeTest();
    }

    @Test(description = "测试新建团课排课")
    public void testCreateGroupRuleSchedule() throws InterruptedException {
        //查询今日待上课的数据
        HomeTools homeTools = new HomeTools();
        int num = homeTools.queryTodaySchedule().getJSONArray("result").size();

        //获取存量课程ID
        String courseId = groupScheduleTools.getStockGroupCourseId(courseName);
        if (courseId == "") {
            //获取存量课程分类ID
            String categoryId = courseCategoryTools.getCourseCategoryPage("普拉提");
            courseId = courseTools.createGroupCourse(courseName, categoryId, "STUDIO");
        }
        //获取存量场地
        List<String> venueAreaIds = groupScheduleTools.getStockArea("流星花园秘密基地");
        //获取存量教练
        List<String> chiefCoachId = new ArrayList<>();
        chiefCoachId.add("杜君丽");
        String chiefCoachIdS = groupScheduleTools.getStudioAdminId(chiefCoachId).get(0).toString();
        //获取存量助教
        List<String> assistCoachIds = new ArrayList<>();
        assistCoachIds.add("木头");
        assistCoachIds.add("吴彦祖");
        List<String> assistCoachIdS = groupScheduleTools.getStudioAdminId(assistCoachIds);

        //1-创建排课日程
        groupScheduleTools.createGroupRuleSchedule(courseId, chiefCoachIdS, todayStartTimeTamp, endDateTimeTamp, venueAreaIds, assistCoachIdS, false, 1,480);
        //2-查询排课日程
        JSONArray result = groupScheduleTools.getGroupRuleScheduleList(courseId, chiefCoachIdS);

        Assert.assertTrue(result.size() >= 1);
        //创建今日待上课的排课后再查询今日待上课的数据
        int num1 = homeTools.queryTodaySchedule().getJSONArray("result").size();
        Assert.assertEquals(num1, num+1);

        //统计查询到的目标日程数量
        int size = result.size();
        String ruldId = XMJSONPath.readPath(result.getJSONObject(0), "$.ruleId");
        groupScheduleTools.delGroupRuleSchedule(ruldId,true);
        Thread.sleep(1000);
        JSONArray result2 = groupScheduleTools.getGroupRuleScheduleList(courseId, chiefCoachIdS);

        //删除成功后，统计查询到的目标日程数量是否-1
        Assert.assertEquals(result2.size(), size - 1);

    }




}

    