package com.xiaomai.cases.polar.training;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;

/**
 * 对报名中的活动操作立即成营
 *
 * @author adu
 * data 2024/7/3 17:53
 */

public class TestDoForceOpenTraining extends BaseCreateTrainingData {
    @Resource(name = "trainingTools")
    TrainingTools trainingTools;
    String id = "";

    @BeforeClass
    @Override
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Training, "API_forceOpenTraining", LoginAccount.ADU_PROD, Terminal.B, "adu");
        super.beforeTest();

    }

    @Test(description = "测试对未开营的活动操作立即成营")
    public void testForceOpenTraining() throws InterruptedException {

        //1.创建训练营活动：保存并发布
        id = trainingTools.createThenPublishTraining(String.valueOf(currentTimestamp + 15000), applyEndTime, courseId, openStartDate,
                openEndDate, 0.01, trainingTitle, 2, 1, trainerListIdS, "YES");
        if (id.isEmpty()) {
            id = trainingTools.createThenPublishTraining(futureTimestampS, applyEndTime, courseId, openStartDate,
                    openEndDate, 0.01, trainingTitle + RandomStringUtil.randomString(3), 2, 1, trainerListIdS, "YES");
        }
        //2.查看活动详情，check 活动状态
        trainingTools.findTrainingDetailById(id);
        String status = XMJSONPath.readPath(dataApi.getApi_response(), "$.result.state");
        //报名未开始APPLY_NOT_START
        if (status.equals("APPLY_NOT_START")) {
            //对报名未开始的活动操作立即成营
            JSONObject body = new JSONObject();
            body.put("operatorId", dataApi.getLoginInfo().getAdminId());
            body.put("studioId", dataApi.getLoginInfo().getStudioId());
            body.put("brandId", dataApi.getLoginInfo().getBrandId());
            body.put("id", id);
            xmAppApi.doRequest(RequestType.JSON, params, body.toString(), headers);
            Assert.assertEquals(XMJSONPath.readPath(xmAppApi.getApi_response(), "$.message"), "只有报名中的训练营能【立即成营】");

        }

        //3.创建成功后，全局搜索check
        Thread.sleep(3000);
        trainingTools.commonSearchTraining(trainingTitle);
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result").size() > 0, "活动创建后，根据活动名称全局搜索没有数据");


        Thread.sleep(10000);//延迟10秒后，活动达到报名时间（可能状态没同步，定时任务没到时间执行，但是数据库中已是报名中）
        //4.对报名中的活动操作立即成营
        JSONObject body1 = new JSONObject();
        body1.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body1.put("studioId", dataApi.getLoginInfo().getStudioId());
        body1.put("brandId", dataApi.getLoginInfo().getBrandId());
        body1.put("id", id);
        xmAppApi.doRequest(RequestType.JSON, params, body1.toString(), headers).assetsSuccess(true);

    }


    @AfterTest(description = "删除此case创建的训练营活动")
    public void delData() {
        if (!id.isEmpty()) {
            trainingTools.deleteTraining(id);
        }

    }
}

    