package com.xiaomai.cases.polar.clue;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.Random;

/**
 * @Author zxy
 * @Description
 * @Date 2024/6/30 17:05
 */
public class TestCreateFeedback extends XMBaseTest {
    MemberTools memberTools = new MemberTools();
    String memberId;
    String feedbackId;
    String feedbackId1;
    int num;
    int num_todo;

    @BeforeMethod
    public void beforeTest(){

        xmAppApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_createFeedback")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("zyx")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "添加跟进记录")
    public void testCreateFeedback(){
        String name = "自动化潜在会员"+ RandomStringUtil.randomString(3);
        String phone = RandomStringUtil.randomMobile("666");

        //若全部线索有数据，则取第一条数据；若无数据则新建一个线索
        JSONArray array = memberTools.searchMember(0,"POTENTIAL").getJSONObject("result").getJSONArray("records");
        int size = array.size();
        if(size == 0){
            memberId = memberTools.create(name,phone).getString("result");
        }
        else {
            memberId = array.getJSONObject(0).getString("id");
        }

        //查询该线索的跟进
        num  = memberTools.searchFeedback(memberId).getJSONObject("result").getJSONArray("records").size();
        num_todo = memberTools.listTodoTask(memberId).getJSONArray("result").size();

        Random random = new Random();
        String[] feedbackMethod = {"PHONE","WECHAT","SMS","VISIT","OTHERS"};
        String[] feedbackResult = {"CONTACTED","INTENTION_CONFIRMED","APPOINTED","EXPERIENCED","REGISTERED","REGISTERED","RENEW_FOLLOW"};

        JSONObject object = new JSONObject();
        object.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        object.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        object.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
        object.put("feedbackContent","自动化测试添加跟进记录");
        object.put("feedbackMethod",feedbackMethod[random.nextInt(5)]);
        object.put("feedbackResult",feedbackResult[random.nextInt(7)]);
        object.put("memberId",memberId);
        object.put("nextFeedbackRemark","自动化测试下次跟进内容");
        object.put("nextFeedbackTime", TimeUtils.getTodayEndTime());

        xmAppApi.doRequest(RequestType.JSON,params,object.toString(),headers).assetsSuccess(true);

        feedbackId = xmAppApi.getBodyInJSON().getString("result");
        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {

        }

        JSONArray jsonArray = memberTools.listTodoTask(memberId).getJSONArray("result");
        feedbackId1 = jsonArray.getJSONObject(0).getString("id");
        int num_todo1  = jsonArray.size();
        int num1  = memberTools.searchFeedback(memberId).getJSONObject("result").getJSONArray("records").size();
        Assert.assertEquals(num1,num+1);
        Assert.assertEquals(num_todo1,num_todo+1);
        Assert.assertEquals(memberTools.summaryFeedback().getJSONObject("result").getString("todayWaitFeedback"),"1");



    }

    @Test(description = "删除跟进",priority = 1)
    public void del(){
        memberTools.deleteFeedback(feedbackId);
        memberTools.deleteFeedback(feedbackId1);

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {

        }

        int num2  = memberTools.searchFeedback(memberId).getJSONObject("result").getJSONArray("records").size();
        int num_todo2  = memberTools.listTodoTask(memberId).getJSONArray("result").size();

        Assert.assertEquals(num2,num);
        Assert.assertEquals(num_todo2,num_todo);

    }
}
