package com.xiaomai.cases.polar.experienceCard;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;


/**
 * @Author zxy
 * @Description
 * @Date 2024/7/12 16:45
 */
public class ExperienceCardTools extends XMBaseTest {
    //是否存在相同名称的卡
    public JSONObject checkTitleDuplicate(String title, String commodityCardType, DataUserInfo... userInfos) {
        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_checkTitleDuplicate")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject object = new JSONObject();
        object.put("brandId", dataApi.getLoginInfo().getBrandId());
        object.put("studioId", dataApi.getLoginInfo().getStudioId());
        object.put("operatorId", dataApi.getLoginInfo().getAdminId());

        object.put("title", title);
        object.put("commodityCardType", commodityCardType);

        dataApi.doRequest(RequestType.JSON, dataparams, object.toString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    //创建体验卡  卡类型commodityCardType；卡名称：title；允许购买体验卡的会员类型：memberStatus；体验卡购买条件限制：purchaseRestriction；使用权益：benefit
    public JSONObject create(String commodityCardType,String title, String memberStatus, String purchaseRestriction,String benefit,Boolean useForActivity, DataUserInfo... userInfos) {
        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_tenantMemberCard_create")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONArray activatePatternList = new JSONArray();//生效方式
        activatePatternList.add("PURCHASE");//即时生效
        activatePatternList.add("FIRST_USED");//首次使用生效
        activatePatternList.add("SPECIFIC_DATE");//指定日期生效

        JSONArray purchaseMemberStateList = new JSONArray();//允许购买的会员状态
        switch (memberStatus) {
            case "全部":
                purchaseMemberStateList.add("POTENTIAL");
                purchaseMemberStateList.add("NORMAL");
                purchaseMemberStateList.add("HISTORY");
                break;
            case "潜在":
                purchaseMemberStateList.add("POTENTIAL");
                break;
            case "正式":
                purchaseMemberStateList.add("NORMAL");
                break;
            case "流失":
                purchaseMemberStateList.add("HISTORY");
                break;
        }

        JSONArray entrancePeriodList = new JSONArray();//入场时间段
        entrancePeriodList.add("0~1435");

        int course_price = 10;//课程权益售价
        int venue_price = 20;//入场权益售价
        int price = 0;//卡的售价

        //课程权益-次数
        JSONObject benefit_course_balance = new JSONObject();
        benefit_course_balance.put("identifier", UUID.randomUUID().toString().replace("-", ""));
        benefit_course_balance.put("benefitType", "BALANCE");//次数
        benefit_course_balance.put("targetScope", "GROUP_CLASS_AND_PERSONAL_COURSE");
        benefit_course_balance.put("balance", "10");
        benefit_course_balance.put("reserveLimitType", "UN_LIMIT");
        benefit_course_balance.put("reserveLimitNumber", 0);
        benefit_course_balance.put("defaultConsumeBalance", 1);
        benefit_course_balance.put("targetType", "COURSE");
        benefit_course_balance.put("price", course_price);//课程权益售价

        //课程权益-期限
        JSONObject benefit_course_period = new JSONObject();
        benefit_course_period.put("identifier", UUID.randomUUID().toString().replace("-", ""));
        benefit_course_period.put("benefitType", "PERIOD");//期限
        benefit_course_period.put("targetScope", "GROUP_CLASS_AND_PERSONAL_COURSE");
        benefit_course_period.put("reserveLimitType", "UN_LIMIT");
        benefit_course_period.put("reserveLimitNumber", 0);
        benefit_course_period.put("targetType", "COURSE");
        benefit_course_period.put("price", course_price);//课程权益售价

        //入场权益-次数
        JSONObject benefit_venue_balance = new JSONObject();
        benefit_venue_balance.put("identifier", UUID.randomUUID().toString().replace("-", ""));
        benefit_venue_balance.put("benefitType", "BALANCE");//次数
        benefit_venue_balance.put("balance", "10");
        benefit_venue_balance.put("defaultConsumeBalance", 1);
        benefit_venue_balance.put("entrancePeriodList", entrancePeriodList);//入场时间段
        benefit_venue_balance.put("targetType", "VENUE");
        benefit_venue_balance.put("targetScope", "VENUE_ENTRANCE_PERIOD");
        benefit_venue_balance.put("price", venue_price);//入场权益售价

        //入场权益-期限
        JSONObject benefit_venue_period = new JSONObject();
        benefit_venue_period.put("identifier", UUID.randomUUID().toString().replace("-", ""));
        benefit_venue_period.put("benefitType", "PERIOD");//期限
        benefit_venue_period.put("entrancePeriodList", entrancePeriodList);//入场时间段
        benefit_venue_period.put("targetType", "VENUE");
        benefit_venue_period.put("targetScope", "VENUE_ENTRANCE_PERIOD");
        benefit_venue_period.put("price", venue_price);//入场权益售价

        //需要创建的权益类型，可以组合也可以单个权益
        List benefitList = new ArrayList();
        switch (benefit) {
            case "课程次数入场次数":
                benefitList.add(benefit_course_balance);
                benefitList.add(benefit_venue_balance);
                price = course_price + venue_price;
                break;
            case "课程期限入场期限":
                benefitList.add(benefit_course_period);
                benefitList.add(benefit_venue_period);
                price = course_price + venue_price;
                break;
            case "课程次数入场期限":
                benefitList.add(benefit_course_balance);
                benefitList.add(benefit_venue_period);
                price = course_price + venue_price;
                break;
            case "课程期限入场次数":
                benefitList.add(benefit_course_period);
                benefitList.add(benefit_venue_balance);
                price = course_price + venue_price;
                break;
            case "课程期限":
                benefitList.add(benefit_course_period);
                price = course_price;
                break;
            case "课程次数":
                benefitList.add(benefit_course_balance);
                price = course_price;
                break;
            case "入场期限":
                benefitList.add(benefit_venue_period);
                price = venue_price;
                break;
            case "入场次数":
                benefitList.add(benefit_venue_balance);
                price = venue_price;
                break;
        }

        String description = "{\"items\":[{\"aspect\":\"\",\"type\":\"TEXT\",\"content\":\"自动化测试脚本创建\"}]}";
        Random random = new Random();
        String stock[] = {"","10"};

        JSONObject object = new JSONObject();
        object.put("brandId", dataApi.getLoginInfo().getBrandId());
        object.put("studioId", dataApi.getLoginInfo().getStudioId());
        object.put("operatorId", dataApi.getLoginInfo().getAdminId());
        object.put("creatorId", dataApi.getLoginInfo().getAdminId());
        object.put("maxIdlePeriod", "7");//首次使用生效方式的最晚生效天数
        object.put("surfaceCornerMark", "自动化测试");//封面标签
        object.put("title", title);


        object.put("validPeriod", "30");//有效期
        object.put("activatePatternList", activatePatternList);//生效方式
        object.put("price", price);//售价
        object.put("underlinePrice", "35");//划线价
        object.put("purchaseNumberLimit", "100");//最大购买数量
        object.put("xcxSaleStatus", "YES");//开启小程序售卖
        object.put("shelfState", "YES");//启用体验卡
        object.put("description", description);//描述
        object.put("benefitList", benefitList);//权益信息

        switch (commodityCardType){
            case "MEMBER_CARD":
                object.put("commodityCardType", "MEMBER_CARD");//卡类型：会员卡
                object.put("sharePeopleLimit","2");//共享人数
                object.put("surfaceUrl", "https://image.xiaomaiketang.com/xm/internal/GKH7tWJTXX.png");//封面
                break;
            case "EXPERIENCE_CARD":
                object.put("useForActivity", useForActivity);//营销活动是否开启
                object.put("stock",stock[random.nextInt(2)]);//剩余库存
                object.put("purchaseMemberStateList", purchaseMemberStateList);//可购卡的会员状态
                object.put("surfaceUrl", "https://image.xiaomaiketang.com/xm/internal/AHZTicf2k7.png");//封面
                object.put("commodityCardType", "EXPERIENCE_CARD");//卡类型：体验卡
                object.put("purchaseRestriction",purchaseRestriction);//购买限制：YES表示限制 NO表示不限制；限制即：不允许购买过其他卡的会员再购买本张卡

                if(useForActivity.equals(true)){ //如果开启用于营销活动
                object.put("stock", -1); //剩余库存不限
                object.put("purchaseNumberLimit",-1);//每人限购不限

                List<String> memberStatusLimitsA=new ArrayList<>();
                memberStatusLimitsA.add("POTENTIAL");
                memberStatusLimitsA.add("NORMAL");
                memberStatusLimitsA.add("HISTORY");
                object.put("memberStatusLimits", memberStatusLimitsA);//可领取会员类型所有类型
                object.put("purchaseRestriction", "NO"); //购买条件不限制
            }
                break;
        }

        dataApi.doRequest(RequestType.JSON, dataparams, object.toString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();

    }


    //卡列表  卡类型commodityCardType；筛选条件filter，有传传对应的类型及参数，无就传空；
    public JSONObject fetchPageOfMemberCard(String commodityCardType,String  filter,String courseId,String shelfState,String xcxSaleStatus,DataUserInfo...dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_fetchPageOfMemberCard")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();

        jsonObject.put("current",0);
        jsonObject.put("size",20);
        jsonObject.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
        jsonObject.put("commodityCardType",commodityCardType);
        switch (filter){
            case "启用状态":
                jsonObject.put("shelfState",shelfState);
                break;
            case "线上售卖":
                jsonObject.put("xcxSaleStatus",xcxSaleStatus);
                break;
            case "适用课程":
                jsonObject.put("courseId",courseId);
                break;
            default:
                jsonObject.put("courseId",null);

        }

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

}
