package com.xiaomai.cases.polar.finance.order;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.member.Tools;
import com.xiaomai.cases.polar.memberCard.CardTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

import java.math.BigDecimal;

public class TestPay extends XMBaseTest {

    String memberId;

    String cardId;
    Tools tools=new Tools();

    OrderTools orderTools=new OrderTools();

    CardTools cardTools=new CardTools();


    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_pay")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("yff")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }


    @Test(description = "收款（继续收款）")
    public void testPay(){


        String name = "创建订单潜在会员"+ RandomStringUtil.randomString(3);
        String phone = RandomStringUtil.randomMobile("666");

        //获取会员ID,没有则新建一个
        int memberTotal = Integer.parseInt(tools.search("NORMAL","NORMAL").getJSONObject("result").getString("total"));
        if (memberTotal == 0) {
            memberId = tools.create(name,phone).getString("result");
        }
        memberId=tools.search("NORMAL","NORMAL").getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        //获取会员卡信息
        //获取会员卡列表,没有则新建一个
        int cardTotal = Integer.parseInt(orderTools.fetchPageOfMemberCard("次卡","MEMBER_CARD").getJSONObject("result").getString("total"));
        if (cardTotal == 0) {
            cardId = cardTools.memberCardCreate("次卡-创建订单会员卡"+ TimeUtils.getCurrentTime()).getString("result");
        }
        JSONObject memberCard=orderTools.fetchPageOfMemberCard("次卡","MEMBER_CARD");
        cardId=memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");
        BigDecimal quantity= new BigDecimal(memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getJSONArray("benefitList").getJSONObject(0).getString("balance"));
        float price= Float.parseFloat(memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("price"));
        int validPeriod= Integer.parseInt(memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("validPeriod"));

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        //获取签单要用的卡快照id
        String latestSnapshotId=orderTools.fetchDetailById(cardId,xmAppApi.getLoginInfo().getBrandId(),xmAppApi.getLoginInfo().getStudioId(),xmAppApi.getLoginInfo().getAdminId()).getJSONObject("result").getString("latestSnapshotId");

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        //检查会员对该卡是否超出购买上限
        boolean limitResult=orderTools.checkAllowPurchase("MEMBER_CARD",cardId,memberId,"1",xmAppApi.getLoginInfo().getBrandId(),xmAppApi.getLoginInfo().getStudioId(),xmAppApi.getLoginInfo().getAdminId()).getBoolean("success");

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }


        if(limitResult == true) {

            //创建部分支付订单
            JSONObject orderResult = orderTools.signOrder(cardId, latestSnapshotId, quantity, price, validPeriod, latestSnapshotId, 0, "PURCHASE",
                    "MEMBER_CARD", memberId, price,price / 2 , "1",false);
            String getDetailId = orderResult.getString("result");


            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }

            //获取订单详情
            JSONObject getDetailResult=orderTools.getDetail(getDetailId);
            String id = getDetailResult.getJSONObject("result").getString("id");//订单id
            String state=getDetailResult.getJSONObject("result").getString("state");
            String unpaidAmount=getDetailResult.getJSONObject("result").getString("unpaidAmount");
            Assert.assertEquals(id.equals(getDetailId),true,"获取创建的订单详情失败");
            Assert.assertEquals(state,"WAITING","获取创建的订单状态为部分支付");


            //继续收款
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("operationTime", TimeUtils.getCurrentTime());
            jsonObject.put("operatorId", xmAppApi.getLoginInfo().getAdminId());

            JSONArray paymentWays = new JSONArray();

            JSONObject jsonObject1 = new JSONObject();
            jsonObject1.put("amount", unpaidAmount);
            jsonObject1.put("paymentWay", "1");//线下微信

            JSONArray voucherResourceIds = new JSONArray();
            voucherResourceIds.add("");
            jsonObject1.put("voucherResourceIds", voucherResourceIds);
            paymentWays.add(jsonObject1);

            jsonObject.put("paymentWays", paymentWays);
            jsonObject.put("voucherId", getDetailId);
            jsonObject.put("brandId", xmAppApi.getLoginInfo().getBrandId());
            jsonObject.put("studioId", xmAppApi.getLoginInfo().getStudioId());

            xmAppApi.doRequest(RequestType.JSON,params,jsonObject.toJSONString(),headers).assetsSuccess(true);
            JSONObject response=xmAppApi.getBodyInJSON();
            String result=response.getString("result");
            Assert.assertEquals(result,"true","继续收款失败");


            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }

            //校验订单状态已完成;继续收款后欠费金额为0;继续收款订单和原部分支付订单为同一个
            //获取订单详情
            JSONObject getDetailResult1=orderTools.getDetail(getDetailId);
            String state1=getDetailResult1.getJSONObject("result").getString("state");
            String unpaidAmount1=getDetailResult1.getJSONObject("result").getString("unpaidAmount");
            String id1=getDetailResult1.getJSONObject("result").getString("id");
            Assert.assertEquals(state1,"PAID","继续收款全部金额后状态未是已完成");
            Assert.assertEquals(unpaidAmount1,"0.0000","继续收款全部金额后欠费金额不是0");
            Assert.assertEquals(id1.equals(getDetailId),true,"继续收款订单不是原部分支付订单");


        }

    }

    @DataProvider
    public Object[][] dataProvider(){
        return new Object[][]{
                {true,"发放商品权益"},
                {false,"不发放商品权益"}
        };
    }

    @Test(dataProvider = "dataProvider")
    public void testSignOrder2(boolean directReceive,String memo) {
        // 查询存量的学员没有则创建学员
        if (tools.commonSearch("刘佳","NORMAL").getJSONArray("result").size()>0){
            memberId = tools.commonSearch("刘佳","NORMAL").getJSONArray("result").getJSONObject(0).getString("id");
        }else if (tools.commonSearch("刘佳","HISTORY").getJSONArray("result").size()>0){
            memberId = tools.commonSearch("刘佳","HISTORY").getJSONArray("result").getJSONObject(0).getString("id");
        }else if (tools.commonSearch("刘佳","POTENTIAL").getJSONArray("result").size()>0){
            memberId = tools.commonSearch("刘佳","POTENTIAL").getJSONArray("result").getJSONObject(0).getString("id");
        }else{
            memberId = tools.create("刘佳", RandomStringUtil.randomMobile("214")).getString("result");
        }


        // 查询存量的卡
        JSONObject fetchPageOfMemberCard = orderTools.fetchPageOfMemberCard("","MEMBER_CARD").getJSONObject("result");
        int total = Integer.parseInt(fetchPageOfMemberCard.getString("total"));
        String cardId = "";
        if (total == 0) {
            cardId = cardTools.memberCardCreate("创建先享后付订单"+ TimeUtils.getCurrentTime()).getString("result");
        }
        cardId = fetchPageOfMemberCard.getJSONArray("records").getJSONObject(0).getString("id");
        BigDecimal quantity =  new BigDecimal(fetchPageOfMemberCard.getJSONArray("records").getJSONObject(0).getJSONArray("benefitList").getJSONObject(0).getString("balance"));
        float price = Float.parseFloat(fetchPageOfMemberCard.getJSONArray("records").getJSONObject(0).getString("price"));
        int validPeriod = Integer.parseInt(fetchPageOfMemberCard.getJSONArray("records").getJSONObject(0).getString("validPeriod"));
        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        //获取签单要用的卡快照id
        String latestSnapshotId = orderTools.fetchDetailById(cardId,xmAppApi.getLoginInfo().getBrandId(),xmAppApi.getLoginInfo().getStudioId(),xmAppApi.getLoginInfo().getAdminId()).getJSONObject("result").getString("latestSnapshotId");

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        //创建待支付订单（不发放商品权益）
        JSONObject orderResult = orderTools.signOrder(cardId, latestSnapshotId, quantity, price, validPeriod, latestSnapshotId, 0, "PURCHASE",
                "MEMBER_CARD", memberId, price,price / 2 , "1", false);
        String getDetailId = orderResult.getString("result");


        //继续收款
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("operationTime", TimeUtils.getCurrentTime());
        jsonObject.put("operatorId", xmAppApi.getLoginInfo().getAdminId());

        JSONArray paymentWays = new JSONArray();

        JSONObject jsonObject1 = new JSONObject();
        jsonObject1.put("amount", 0.01);
        jsonObject1.put("paymentWay", "1");//线下微信

        JSONArray voucherResourceIds = new JSONArray();
        voucherResourceIds.add("");
        jsonObject1.put("voucherResourceIds", voucherResourceIds);
        paymentWays.add(jsonObject1);

        jsonObject.put("paymentWays", paymentWays);
        jsonObject.put("voucherId", getDetailId);
        jsonObject.put("directReceive", directReceive);
        jsonObject.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", xmAppApi.getLoginInfo().getStudioId());

        xmAppApi.doRequest(RequestType.JSON,params,jsonObject.toJSONString(),headers).assetsSuccess(true);


        try {
            Thread.sleep(5000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        JSONObject getDetailResult = orderTools.getDetail(getDetailId);
        String businessNo = getDetailResult.getJSONObject("result").getString("businessNo");
        String state = getDetailResult.getJSONObject("result").getString("state");
        if (directReceive){
            Assert.assertEquals(state,"DELINQUENT","选择先使用后补交，订单状态为待补交状态");
        }else{
            Assert.assertEquals(state,"WAITING","选择全额支付后才发放商品，订单状态为待支付状态");
        }

        //校验获取会员下的购买的会员卡是否生成卡包
        //获取会员下的购买的会员卡
        JSONObject fetchUserCardListResult=orderTools.fetchUserCardList("MEMBER",memberId,"NORMAL");
        if (directReceive){
            String fetchUserCardListId=fetchUserCardListResult.getJSONArray("result").getJSONObject(0).getString("id");//memberCardId

            //获取售卖详情
            JSONObject findDetailByIdResult=cardTools.memberCardFindDetailById(fetchUserCardListId);
            String findDetailByIdTradeOrderNumber = findDetailByIdResult.getJSONObject("result").getString("tradeOrderNumber");//订单号
            Assert.assertEquals(findDetailByIdTradeOrderNumber.equals(businessNo),true,"已发放商品，未生成卡包");//断言的别意：生成的卡包的订单号和上述创建订单的订单号一致不一致的校验
        }else {
            if (fetchUserCardListResult.getJSONArray("result").size()>0){
                String fetchUserCardListId=fetchUserCardListResult.getJSONArray("result").getJSONObject(0).getString("id");//memberCardId
                //获取售卖详情
                JSONObject findDetailByIdResult=cardTools.memberCardFindDetailById(fetchUserCardListId);
                String findDetailByIdTradeOrderNumber = findDetailByIdResult.getJSONObject("result").getString("tradeOrderNumber");//订单号
                Assert.assertEquals(!findDetailByIdTradeOrderNumber.equals(businessNo),true,"未发放商品，生成了卡包");//断言的别意：生成的卡包的订单号和上述创建订单的订单号一致不一致的校验
            }
        }

        orderTools.discard(getDetailId, "重复录入","作废订单");

    }
}
