package com.xiaomai.cases.polar.importExcel;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.enums.ExcelImportEnum;
import com.xiaomai.cases.polar.utils.Entity.SignatureVO;
import com.xiaomai.cases.polar.utils.ModifyExcelContentUtil;
import com.xiaomai.cases.polar.utils.ResourceUtil;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TestImportDeposit extends XMBaseTest {
    ImportTools importTools = new ImportTools();
    @BeforeMethod
    public void beforeTest(){

        xmAppApi.setApiModule(ApiModule.Polar_ImportTask)
                .setApiName("API_webTokenWithAccessUrl")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("xyy")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "导入售出储值卡")
    public void testImportMember()throws IOException, InterruptedException{
        //导入任务列表
        int total = Integer.parseInt(importTools.pageImportTask().getJSONObject("result").getString("total"));
        //1.更新excel文档
        String filePathName = "excelFile/depositInfo.xls";
        ModifyExcelContentUtil.modifyExcel(filePathName, "售出储值卡导入", ExcelImportEnum.DEPOSIT_INFO);
        Thread.sleep(1000);

        //2、获取签名
        JSONObject object = new JSONObject();
        object.put("brandId", xmAppApi.getLoginInfo().getBrandId());
//        object.put("tenantType", "BRAND");
        object.put("resourceName",filePathName);
        object.put("resourceNameToMD5",false);
        object.put("bizCode","IMPORT_TASK");
        xmAppApi.doRequest(RequestType.JSON, params, object.toString(), headers).assetsSuccess(true);
        JSONObject result1 = xmAppApi.getBodyInJSON();
        String resourceId = XMJSONPath.readPath(result1, "$.result.resourceId");
        String accessId = XMJSONPath.readPath(result1, "$.result.accessKeyId");
        String policy = XMJSONPath.readPath(result1, "$.result.policy");
        String signature = XMJSONPath.readPath(result1, "$.result.signature");
        String key = XMJSONPath.readPath(result1, "$.result.key");
        String callback = XMJSONPath.readPath(result1, "$.result.callback");
        String securityToken = XMJSONPath.readPath(result1, "$.result.securityToken");
        String host = XMJSONPath.readPath(result1, "$.result.host");
        String time = XMJSONPath.readPath(result1, "$.result.extAttrs");
        JSONObject time1 = JSONObject.parseObject(time);
        String url = XMJSONPath.readPath(result1, "$.result.url");

        //3.腾讯云上传
        InputStream inputStream = new FileInputStream(filePathName);
        SignatureVO signatureVO = new SignatureVO();
        signatureVO.setAlgorithm("sha1");
        signatureVO.setKey(key);
        signatureVO.setAccessId(accessId);
        signatureVO.setPolicy(policy);
        signatureVO.setSignature(signature);
        signatureVO.setCallback(callback);
        signatureVO.setSecurityToken(securityToken);
        signatureVO.setExtAttrs(time1.getString("q-key-time"));
        signatureVO.setHost(host);
        signatureVO.setResourceId(Long.valueOf(resourceId));

        String result = String.valueOf(ResourceUtil.uploadFileContentToTencent(inputStream, filePathName, signatureVO, 5000,"multipart/form-data"));
        Assert.assertEquals(result, "true");
        Thread.sleep(6000);

        //4.创建任务
        JSONObject result2 = importTools.createImportTask("DEPOSIT_CARD_ORDER",resourceId,null,"");
        String recordId = XMJSONPath.readPath(result2, "$.result");

        //5.获取上传进度
        Thread.sleep(6000);
        importTools.getTask(recordId);
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.state"), "SUCCESS");
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.successRowNum"), "1");

        //上传成功后导入记录列表新增一条数据
        JSONObject res = importTools.pageImportTask().getJSONObject("result");
        Assert.assertEquals(Integer.parseInt(res.getString("total")),total+1);
        Assert.assertEquals(res.getJSONArray("records").getJSONObject(0).getString("resourceId"),resourceId);
        Assert.assertEquals(res.getJSONArray("records").getJSONObject(0).getString("state"),"SUCCESS");

    }

}
