package com.xiaomai.cases.polar.memberCard.MemberCardTimeSale;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.polar.memberCard.CardTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;

public class TestPublish extends BaseTestImpl {
    @Resource(name = "cardTools")
    CardTools cardTools;
    @Resource(name = "memberCardTimeSaleTools")
    MemberCardTimeSaleTools MemberCardTimeSaleTools;
    @BeforeClass
    @Override
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Card, "API_studioSeckill_publish", LoginAccount.ADU_PROD, Terminal.B, "yangjian");
        super.beforeTest();
    }
    @Test(description = "发布秒杀活动动")
    public void testStudioSeckill_publish() throws InterruptedException {
        Thread.sleep(2000);
        String cardId = cardTools.memberCardCreate("用于秒杀活动的会员卡"+ TimeUtils.getCurrentTime()).getString("result");//创建一张用于秒杀活动的会员卡
        String title ="未发布的秒杀活动"+ TimeUtils.getCurrentTime();
        JSONObject result1 =MemberCardTimeSaleTools.getStudioActivityPage("UNPUBLISHED");//未发布条数;
        int before=Integer.parseInt(result1.getJSONObject("result").getString("total"));
        String activeid = MemberCardTimeSaleTools.create(cardId,title,false,TimeUtils.getTodayEndTime(),TimeUtils.getTodayTime()).getString("result");//创建一个未发布的秒杀活动
        JSONObject result2 =MemberCardTimeSaleTools.getStudioActivityPage("UNPUBLISHED");//未发布条数;
        int after=Integer.parseInt(result2.getJSONObject("result").getString("total"));
        Assert.assertEquals(after,before+1);//未发布活动+1
        MemberCardTimeSaleTools.getStudioActivityById(activeid);
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.state"), "UNPUBLISHED", "目标活动非未发布状态");//断言目标活动非发布状态


        JSONObject jsonObject = new JSONObject();

        jsonObject.put("activityId",activeid);
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);


        JSONObject result3 =MemberCardTimeSaleTools.getStudioActivityPage("UNPUBLISHED");//未发布条数;
        int after2=Integer.parseInt(result3.getJSONObject("result").getString("total"));
        Assert.assertEquals(after2,after-1);//未发布活动-1
        MemberCardTimeSaleTools.getStudioActivityById(activeid);
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.state"), "PROCESSING", "目标活动非进行中状态");//断言目标活动进行中状态

        MemberCardTimeSaleTools.studioSeckillDeleteById(activeid);//删除秒杀活动


    }
}
