package com.xiaomai.cases.polar.memberCard;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

import javax.annotation.Resource;

public class TestModifyShelfState extends XMBaseTest {
    @Resource(name = "cardTools")
    CardTools cardTools;

    public String memberCardId = "";
    public String shelfState;
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_modifyShelfState")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("yj")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @DataProvider
    public  Object[][] dataProvider(){
        return new Object[][]{
                {"MEMBER_CARD"},//会员卡
                {"DEPOSIT_CARD"},//储值卡
                {"EXPERIENCE_CARD"}//体验卡
        };
    }


    @Test(description = "停用卡",dataProvider = "dataProvider")
    public void testModifyShelfState_NO(String cardType) {
        cardTools.fetchPageOfMemberCard(cardType);
        //先检查列表有没有数据，有数据才会执行下面的点代码（如果是个空机构，肯定不会被执行，想从存量数据中获取，需要自己先造个数据）
        int listDatas = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.records").size();
        if (listDatas > 0) {
            memberCardId = XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].id");
            //取出第一个数据后，要check下会员卡的启用状态，想停用，要保证卡的状态目前就是启用状态
            shelfState=XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].shelfState");
            //如果不是启用状态，则开启
            if(shelfState.equals("NO")){
              cardTools.modifyMemberCardShelfState(memberCardId,"YES");
            }

            JSONObject jsonObject = new JSONObject();
            jsonObject.put("shelfState", "NO");
            jsonObject.put("memberCardId", memberCardId);
            jsonObject.put("brandId", xmAppApi.getLoginInfo().getBrandId());
            jsonObject.put("studioId", xmAppApi.getLoginInfo().getStudioId());
            jsonObject.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
            xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);

            //check 会员卡详情，查看状态是否是下架状态
            cardTools.fetchDetailById(memberCardId);
            Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(),"$.result.shelfState"),"NO","操作停用会员卡后，查看卡详情，卡启用状态没变更为NO");

        }
    }
    @Test(description = "启用卡",dataProvider = "dataProvider")
    public void testModifyShelfState_YES(String cardType) {
        cardTools.fetchPageOfMemberCard(cardType);
        int listDatas = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.records").size();
        if (listDatas > 0) {
            memberCardId = XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].id");
            shelfState = XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].shelfState");
            if (shelfState.equals("YES")) {
                cardTools.modifyMemberCardShelfState(memberCardId, "NO");
            }
            JSONObject jsonObject = new JSONObject();

            jsonObject.put("shelfState", "YES");
            jsonObject.put("memberCardId", memberCardId);
            jsonObject.put("brandId", xmAppApi.getLoginInfo().getBrandId());
            jsonObject.put("studioId", xmAppApi.getLoginInfo().getStudioId());
            jsonObject.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
            xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);
            //check 会员卡详情，查看状态是否是上架状态
            cardTools.fetchDetailById(memberCardId);
            Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.shelfState"), "YES", "操作启用会员卡后，查看卡详情，卡启用状态没变更为YES");


        }
    }

}
