package com.xiaomai.cases.lunar.goods;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.lunar.order.OrderCTools;
import com.xiaomai.cases.lunar.user.UserTools;
import com.xiaomai.cases.polar.finance.order.OrderTools;
import com.xiaomai.cases.polar.goods.Tools.GoodTools;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.math.BigDecimal;

public class TestPurchaseGoods extends BaseTestImpl {

    GoodCTools goodCTools=new GoodCTools();
    GoodTools goodTools=new GoodTools();

    String memberId;

    UserTools userTools=new UserTools();

    DataUserInfo info = new DataUserInfo();

    String goodsId1;
    String goodsId2;
    String goodsId3;


    OrderCTools orderCTools=new OrderCTools();

    OrderTools orderTools=new OrderTools();


    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Lunar_Goods,"API_purchaseGoods", LoginAccount.GYM_MINIAPPC, Terminal.minApp,"yff");
        super.beforeTest();
    }


    @Test(description = "购买非0元多规格物品")
    public void testPurchaseGoods_WAITING() {

        //获取会员信息
        memberId = userTools.getMemberInfo().getString("memberId");


        //切换端位
        info.setTerminal(Terminal.B);
        info.setLoginUser(LoginAccount.GYM_PROD);

        //新建一个非0多规格物品
        JSONObject create=goodTools.createGoods_multiple("YES","0.01",10,info);
        goodsId1=create.getString("result");
        //获取商品详情
        JSONObject getDetail_goods_C=goodCTools.getDetail_goods_C(goodsId1,info);
        String id=getDetail_goods_C.getJSONObject("result").getJSONObject("multiSpecInfo").getJSONArray("specCombinationList").getJSONObject(0).getString("id");
        String price=getDetail_goods_C.getJSONObject("result").getJSONObject("multiSpecInfo").getJSONArray("specCombinationList").getJSONObject(0).getString("price");
        int inventory=Integer.parseInt(getDetail_goods_C.getJSONObject("result").getJSONObject("multiSpecInfo").getJSONArray("specCombinationList").getJSONObject(0).getString("inventory"));

        boolean checkAllowPurchase=Boolean.parseBoolean(goodCTools.checkAllowPurchase(id,memberId,price,inventory).getJSONObject("result").getString("success"));

        //校验一下物品购买是否可以通过，为true才可以
        if(checkAllowPurchase==true){


            //购买非0元多规格物品
            JSONObject  purchaseGoods=new JSONObject();
            purchaseGoods.put("depositAmount","0.00");
            purchaseGoods.put("depositCardId",null);
            purchaseGoods.put("memberId",memberId);
            purchaseGoods.put("memo","");
            purchaseGoods.put("objectId", RandomStringUtil.randomString(16));
            purchaseGoods.put("receivableAmount",price);
            purchaseGoods.put("goodsSpecId",id);
            purchaseGoods.put("price",price);
            purchaseGoods.put("quantity",1);
            purchaseGoods.put("studioId",dataApi.getLoginInfo().getStudioId());

            xmAppApi.doRequest(RequestType.JSON, params, purchaseGoods.toString(), headers).assetsSuccess(true);
            JSONObject purchaseGoodsResponse = xmAppApi.getBodyInJSON();
            String orderId=purchaseGoodsResponse.getJSONObject("result").getString("id");

            //校验1：获取B端详情：待支付状态
            JSONObject getDetailResult = orderTools.getDetail(orderId,info);
            String businessNo= getDetailResult.getJSONObject("result").getString("businessNo");//订单号
            String state=getDetailResult.getJSONObject("result").getString("state");
            Assert.assertEquals(state,"WAITING","未生成待支付物品订单");

            try {
                Thread.sleep(3000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }




            //C端取消订单

            JSONObject cancel=orderCTools.cancel(orderId);

            //校验1：获取B端详情：已取消状态
            JSONObject getDetailResult_cancel = orderTools.getDetail(orderId,info);
            String businessNo_cancel= getDetailResult_cancel.getJSONObject("result").getString("businessNo");//订单号
            String state_cancel=getDetailResult_cancel.getJSONObject("result").getString("state");
            Assert.assertEquals(state_cancel,"CANCEL","未生成待支付物品订单");


        }
        else {
            System.out.println("物品购买校验未通过，不能下单");
        }

    }


    @Test(description = "购买0元多规格物品")
    public void testPurchaseGoods_PAID() {

        //获取会员信息
        memberId = userTools.getMemberInfo().getString("memberId");

        //切换端位
        info.setTerminal(Terminal.B);
        info.setLoginUser(LoginAccount.GYM_PROD);


        //新建一个0元多规格物品
        JSONObject create=goodTools.createGoods_multiple("YES","0.00",10,info);
        goodsId2=create.getString("result");
        //获取商品详情
        JSONObject getDetail_goods_C=goodCTools.getDetail_goods_C(goodsId2,info);
        String id=getDetail_goods_C.getJSONObject("result").getJSONObject("multiSpecInfo").getJSONArray("specCombinationList").getJSONObject(0).getString("id");
        BigDecimal price=new BigDecimal(getDetail_goods_C.getJSONObject("result").getJSONObject("multiSpecInfo").getJSONArray("specCombinationList").getJSONObject(0).getString("price"));
        int inventory=Integer.parseInt(getDetail_goods_C.getJSONObject("result").getJSONObject("multiSpecInfo").getJSONArray("specCombinationList").getJSONObject(0).getString("inventory"));

        boolean checkAllowPurchase=Boolean.parseBoolean(goodCTools.checkAllowPurchase(id,memberId,"0.00",inventory).getJSONObject("result").getString("success"));

        //校验一下物品购买是否可以通过，为true才可以
        if(checkAllowPurchase==true){


            //购买非0元多规格物品
            JSONObject  purchaseGoods=new JSONObject();
            purchaseGoods.put("depositAmount","0.00");
            purchaseGoods.put("depositCardId",null);
            purchaseGoods.put("memberId",memberId);
            purchaseGoods.put("memo","");
            purchaseGoods.put("objectId", RandomStringUtil.randomString(16));
            purchaseGoods.put("receivableAmount",price);
            purchaseGoods.put("goodsSpecId",id);
            purchaseGoods.put("price",price);
            purchaseGoods.put("quantity",1);
            purchaseGoods.put("studioId",dataApi.getLoginInfo().getStudioId());

            xmAppApi.doRequest(RequestType.JSON, params, purchaseGoods.toString(), headers).assetsSuccess(true);
            JSONObject purchaseGoodsResponse = xmAppApi.getBodyInJSON();
            String orderId=purchaseGoodsResponse.getJSONObject("result").getString("id");

            //校验1：获取B端详情：待支付状态
            JSONObject getDetailResult = orderTools.getDetail(orderId,info);
            String businessNo= getDetailResult.getJSONObject("result").getString("businessNo");//订单号
            String state=getDetailResult.getJSONObject("result").getString("state");
            Assert.assertEquals(state,"PAID","未生成已完成物品订单");


            try {
                Thread.sleep(3000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }

        }
        else {
            System.out.println("物品购买校验未通过，不能下单");
        }


    }


    @Test(description = "购买0元单规格物品")
    public void testPurchaseGoods_PAID_single() {

        //获取会员信息
        memberId = userTools.getMemberInfo().getString("memberId");

        //切换端位
        info.setTerminal(Terminal.B);
        info.setLoginUser(LoginAccount.GYM_PROD);


        try {
            Thread.sleep(3000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }


        //新建一个0元单规格物品
        JSONObject create=goodTools.createGoods_single("YES","0.00",10,info);
        goodsId3=create.getString("result");
        //获取商品详情
        JSONObject getDetail_goods_C=goodCTools.getDetail_goods_C(goodsId3,info);
        String id=getDetail_goods_C.getJSONObject("result").getString("id");
        BigDecimal price=new BigDecimal(getDetail_goods_C.getJSONObject("result").getJSONObject("singleSpecInfo").getString("price"));
        int inventory=Integer.parseInt(getDetail_goods_C.getJSONObject("result").getJSONObject("singleSpecInfo").getString("inventory"));

        boolean checkAllowPurchase=Boolean.parseBoolean(goodCTools.checkAllowPurchase(id,memberId,"0.00",inventory).getJSONObject("result").getString("success"));

        //校验一下物品购买是否可以通过，为true才可以
        if(checkAllowPurchase==true){


            //购买0元单规格物品
            JSONObject  purchaseGoods=new JSONObject();
            purchaseGoods.put("depositAmount","0.00");
            purchaseGoods.put("depositCardId",null);
            purchaseGoods.put("memberId",memberId);
            purchaseGoods.put("memo","");
            purchaseGoods.put("objectId", RandomStringUtil.randomString(16));
            purchaseGoods.put("receivableAmount",price);
            purchaseGoods.put("goodsSpecId",goodsId3);
            purchaseGoods.put("price",price);
            purchaseGoods.put("quantity",1);
            purchaseGoods.put("studioId",dataApi.getLoginInfo().getStudioId());

            xmAppApi.doRequest(RequestType.JSON, params, purchaseGoods.toString(), headers).assetsSuccess(true);
            JSONObject purchaseGoodsResponse = xmAppApi.getBodyInJSON();
            String orderId=purchaseGoodsResponse.getJSONObject("result").getString("id");

            //校验1：获取B端详情：已完成状态
            JSONObject getDetailResult = orderTools.getDetail(orderId,info);
            String businessNo= getDetailResult.getJSONObject("result").getString("businessNo");//订单号
            String state=getDetailResult.getJSONObject("result").getString("state");
            Assert.assertEquals(state,"PAID","未生成已完成物品订单");



        }
        else {
            System.out.println("物品购买校验未通过，不能下单");
        }


    }

//    @Test(description = "清理物品数据",priority = 1)
//    public void delete() {
//        goodTools.deleteGoods(goodsId1,info);
//        try {
//            Thread.sleep(3000);
//        } catch (InterruptedException e) {
//            throw new RuntimeException(e);
//        }
//        goodTools.deleteGoods(goodsId2,info);
//        try {
//            Thread.sleep(3000);
//        } catch (InterruptedException e) {
//            throw new RuntimeException(e);
//        }
//        goodTools.deleteGoods(goodsId3,info);
//
//    }
    }
