package com.xiaomai.cases.polar.goods;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.goods.Tools.GoodTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestDeleteGood extends XMBaseTest {

    GoodTools goodTools=new GoodTools();

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModule.Polar_Goods)
                .setApiName("API_delete")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("yff")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }


    @Test(description = "删除物品")
    public void testCreateGoods() {

        //新建物品
        JSONObject createGoods=goodTools.createGoods_multiple("YES","0.01",10);
        String id=createGoods.getString("result");


        //获取物品列表
        JSONObject studioGoods= goodTools.studioGoods();

        JSONArray records=studioGoods.getJSONObject("result").getJSONArray("records");
        boolean success=false;
        for (int i=0;i<records.size();i++){
            if(records.getJSONObject(i).getString("id").equals(id)){
                success=true;
            }
            Assert.assertEquals(success,true,"新建物品成功，但物品列表没有新增此条数据");
        }

        //删除物品
        JSONObject jsonObject = new JSONObject();

        jsonObject.put("id", id);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);

        try {
            Thread.sleep(3000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        //校验1：物品列表中没有此数据
        JSONObject afterStudioGoods= goodTools.studioGoods();

        JSONArray afterRecords=afterStudioGoods.getJSONObject("result").getJSONArray("records");
        boolean afterSuccess=false;
        for (int i=0;i<afterRecords.size();i++){
            if( ! afterRecords.getJSONObject(i).getString("id").equals(id)){
                afterSuccess=true;
            }
            Assert.assertEquals(afterSuccess,true,"删除物品成功，但物品列表还有此条数据");
        }



    }

//    @Test
//    public void xun(){
//        for(int i=0;i<20;i++){
//            testCreateGoods();
//        }
//    }
}