package com.xiaomai.cases.polar.luckyDraw;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import org.springframework.stereotype.Component;

@Component("luckyDrawTools")
public class LuckyDrawTools extends BaseTestImpl {
    /**
     * 查看幸运抽奖列表
     * @param name 全局搜索中 根据活动名称搜索
     */
    public JSONObject getLuckyDrawByPage(String name,DataUserInfo... userInfo){
        dataApi.setApiModule(ApiModule.Polar_LuckyDraw)
                .setApiName("API_getLuckyDrawByPage")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfo);

        JSONObject body = new JSONObject();
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("current",0);
        body.put("size",10);
        if (null != name || !name.isEmpty()) {
            body.put("name", name);
        }
//        if (null != status || !status.isEmpty()) {
//            body.put("status", status);
//        }
        dataApi.doRequest(RequestType.JSON, dataparams, body.toString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }
    /**
     * 查看优惠券列表
     * @param nameLike 全局搜索中 根据优惠券名称搜索
     */
    public JSONObject getStudioCouponList(String nameLike,DataUserInfo...userInfo){
        dataApi.setApiModule(ApiModule.Polar_Coupon)
                .setApiName("API_getStudioCouponList")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfo);

        JSONObject body = new JSONObject();
        body.put("status","CLAIMABLE");//可领取的优惠券
        body.put("useForActivity",true);//是否开启用于营销活动
        body.put("current",0);
        body.put("size",20);
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        if (null != nameLike || !nameLike.isEmpty()) {
            body.put("nameLike", nameLike);
        }
        dataApi.doRequest(RequestType.JSON, dataparams, body.toString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();

    }
    /**
     * 查询用于营销活动的体验卡
     * @param title
     * @param userInfo
     * @return
     */
    public JSONObject getPageOfMemberCard(String title,DataUserInfo...userInfo) {
        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_fetchPageOfMemberCard")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfo);

        JSONObject body = new JSONObject();
        body.put("shelfState","YES");//启用状态
        body.put("current", 0);
        body.put("size", 20);
        body.put("useForActivity", true);//是否开启营销活动
        body.put("commodityCardType","EXPERIENCE_CARD");
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        if (null != title || !title.isEmpty()) {
            body.put("title", title);
        }
        dataApi.doRequest(RequestType.JSON, dataparams, body.toJSONString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * 自定义奖品列表
     * @param prizeName
     * @param userInfo
     * @return
     */
    public JSONObject getCustomizePrizeByPage(String prizeName,DataUserInfo...userInfo) {
        dataApi.setApiModule(ApiModule.Polar_LuckyDraw)
                .setApiName("API_getCustomizePrizeByPage")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfo);

        JSONObject body = new JSONObject();
        body.put("current", 0);
        body.put("size", 20);
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        if (null != prizeName || !prizeName.isEmpty()) {
            body.put("prizeName", prizeName);
        }
        dataApi.doRequest(RequestType.JSON, dataparams, body.toJSONString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * 创建自定义奖品
     * @param prizeName
     * @param userInfo
     * @return
     */
    public String addCustomizePrize(String prizeName,DataUserInfo...userInfo) {
        dataApi.setApiModule(ApiModule.Polar_LuckyDraw)
                .setApiName("API_addCustomizePrize")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfo);

        JSONObject body = new JSONObject();
        body.put("prizeName", prizeName);
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, body.toJSONString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getString("result");
    }

    /**
     * 删除自定义奖品
     * @param prizeId
     * @param userInfo
     * @return
     */
    public JSONObject delCustomizePrize(String prizeId, DataUserInfo...userInfo) {
        dataApi.setApiModule(ApiModule.Polar_LuckyDraw)
                .setApiName("API_delCustomizePrize")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfo);

        JSONObject body = new JSONObject();
        body.put("id", prizeId);
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, body.toJSONString(), dataheadrs);
        return dataApi.getBodyInJSON();
    }

    /**
     * 创建幸运抽奖：主要创建活动是未开始的活动，可以通过编辑改活动为进行中
     */
    public String addLuckyDraw(String prizeType,String prizeName,String prizeId,boolean publish,String activityName,DataUserInfo...userInfo) {
        dataApi.setApiModule(ApiModule.Polar_LuckyDraw)
                .setApiName("API_addLuckyDraw")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfo);

        String[] applyMemberStates = {"POTENTIAL", "NORMAL", "HISTORY"};
        JSONArray prizeList = new JSONArray();
        JSONObject prize = new JSONObject();
        switch(prizeType){
            case "COUPON":
                prize.put("prizeType",prizeType);//优惠券
                prize.put("stock","100");//奖品数量
                prize.put("probability","100");//中奖概率
                prize.put("prizeImgId","1");
                prize.put("prizeName",prizeName);
                prize.put("prizeId",prizeId);
                break;
            case "EXPERIENCE_CARD":
                prize.put("prizeType",prizeType);//体验卡
                prize.put("stock","100");
                prize.put("probability","100");
                prize.put("prizeImgId","2");
                prize.put("prizeName",prizeName);
                prize.put("prizeId",prizeId);
                break;
            case "CUSTOMIZE_GIFT":
                prize.put("prizeType",prizeType);//自定义奖品
                prize.put("stock","100");
                prize.put("probability","100");
                prize.put("prizeImgId","3");
                prize.put("period","100");//兑奖时效
                prize.put("prizeName",prizeName);
                prize.put("prizeId",prizeId);
        }
        prizeList.add(prize);

        JSONObject body = new JSONObject();
        body.put("actWay", "SUDOKU");
        body.put("applyMemberStates", applyMemberStates);
        body.put("name", activityName);
        body.put("endTime", TimeUtils.getAfterDayDate(30));//活动结束时间：当前时间往后30天
        body.put("maxWinNumber","100");//最多可中奖次数
        body.put("noWinImgId","0");//未中奖图
        body.put("noWinName", "谢谢惠顾");
        body.put("publish",publish);//是否发布
        body.put("actDescribe","自动化脚本创建幸运抽奖");
        body.put("startTime",TimeUtils.getAfterDayDate(1));//活动开始时间：当前时间往后1天
        body.put("prizeList",prizeList);
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        if(publish==false){
            body.put("totalLimit",100);//每人总共抽100次
        }else {
            body.put("dailyLimit",100);//每人每日抽100次
        }

        dataApi.doRequest(RequestType.JSON, dataparams, body.toJSONString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getString("result");
    }

    /**
     * 发布幸运抽奖
     * @param activityId
     * @param userInfo
     */
    public void publishLuckyDraw(String activityId,DataUserInfo...userInfo) {
        dataApi.setApiModule(ApiModule.Polar_LuckyDraw)
                .setApiName("API_publishLuckyDraw")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfo);

        JSONObject body = new JSONObject();
        body.put("id", activityId);
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, body.toJSONString(), dataheadrs).assetsSuccess(true);
    }
    /**
     * 编辑幸运抽奖，主要改活动为进行中
     * @param prizeType
     * @param prizeId
     * @param prizeName
     * @param userInfo
     */
    public void editLuckyDraw(String prizeType,String prizeNo,String prizeName,String prizeId,boolean publish,String activityId,String activityName,DataUserInfo...userInfo) {
        dataApi.setApiModule(ApiModule.Polar_LuckyDraw)
                .setApiName("API_editLuckyDraw")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfo);

        String[] applyMemberStates = {"POTENTIAL", "NORMAL", "HISTORY"};
        JSONArray prizeList = new JSONArray();
        JSONObject prize = new JSONObject();
        switch(prizeType){
            case "COUPON":
                prize.put("id",prizeNo);
                prize.put("activityId",activityId);
                prize.put("prizeType",prizeType);//优惠券
                prize.put("stock","100");//奖品数量
                prize.put("probability","100");//中奖概率
                prize.put("prizeImgId","1");
                prize.put("prizeName",prizeName);
                prize.put("prizeId",prizeId);
                break;
            case "EXPERIENCE_CARD":
                prize.put("id",prizeNo);
                prize.put("activityId",activityId);
                prize.put("prizeType",prizeType);//体验卡
                prize.put("stock","100");
                prize.put("probability","100");
                prize.put("prizeImgId","2");
                prize.put("prizeName",prizeName);
                prize.put("prizeId",prizeId);
                break;
            case "CUSTOMIZE_GIFT":
                prize.put("id",prizeNo);
                prize.put("activityId",activityId);
                prize.put("prizeType",prizeType);//自定义奖品
                prize.put("stock","100");
                prize.put("probability","100");
                prize.put("prizeImgId","3");
                prize.put("period","100");//兑奖时效
                prize.put("prizeName",prizeName);
                prize.put("prizeId",prizeId);
        }
        prizeList.add(prize);

        JSONObject body = new JSONObject();
        body.put("actWay", "SUDOKU");
        body.put("applyMemberStates", applyMemberStates);
        body.put("name", activityName);
        body.put("endTime", TimeUtils.getAfterDayDate(30));//活动结束时间：当前时间往后30天
        body.put("maxWinNumber", "100");//最多可中奖次数
        body.put("noWinImgId", 0);//未中奖图
        body.put("noWinName", "谢谢惠顾");
        body.put("publish",publish);//是否发布
        body.put("actDescribe","自动化脚本edit幸运抽奖");
        body.put("startTime",System.currentTimeMillis());//活动开始时间：当前时间
        body.put("prizeList",prizeList);
        body.put("id",activityId);
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        if(publish==true){
            body.put("dailyLimit",100);//每人每日抽100次
        }else {
            body.put("totalLimit",100);//每人总共抽100次
        }
        dataApi.doRequest(RequestType.JSON, dataparams, body.toJSONString(), dataheadrs).assetsSuccess(true);
    }
    /**
     * 删除幸运抽奖
     * @param activityId
     * @param userInfo
     */
    public void deleteLuckyDraw(String activityId,DataUserInfo...userInfo) {
        dataApi.setApiModule(ApiModule.Polar_LuckyDraw)
                .setApiName("API_deleteLuckyDraw")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfo);

        JSONObject body = new JSONObject();
        body.put("id", activityId);
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, body.toJSONString(), dataheadrs).assetsSuccess(true);
    }
    /**
     * 查看幸运抽奖活动详情
     * @param activityId
     * @param userInfo
     * @return
     */
    public JSONObject getLuckyDrawDetail(String activityId,DataUserInfo...userInfo) {
        dataApi.setApiModule(ApiModule.Polar_LuckyDraw)
                .setApiName("API_getLuckyDrawDetail")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfo);

        JSONObject body = new JSONObject();
        body.put("id",activityId);
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, body.toJSONString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }
    /**
     * 查看活动数据-奖品消耗
     * @param activityId
     * @param userInfo
     * @return
     */
    public JSONObject getLuckyPrizeCount(String activityId,DataUserInfo...userInfo) {
        dataApi.setApiModule(ApiModule.Polar_LuckyDraw)
                .setApiName("API_getLuckyPrizeCount")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfo);

        JSONObject body = new JSONObject();
        body.put("id",activityId);
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, body.toJSONString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * 查看活动数据-参与记录
     * @param activityId
     * @param userInfo
     * @return
     */
    public JSONObject getLuckyAttendByPage(String activityId,DataUserInfo...userInfo) {
        dataApi.setApiModule(ApiModule.Polar_LuckyDraw)
                .setApiName("API_getLuckyAttendByPage")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfo);

        JSONObject body = new JSONObject();
        body.put("startCreated",null);
        body.put("endCreated",null);
        body.put("memberId",null);
        body.put("current",0);
        body.put("size",10);
        body.put("actId",activityId);
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, body.toJSONString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * 小程序获取抽奖次数
     * @param activityId
     * @return
     */
    public int getDrawNum(String activityId,String memberId,DataUserInfo...userInfos) {
        dataApi.setApiModule(ApiModule.Lunar_LuckyDraw)
                .setApiName("API_getDrawNum")
                .setTerminal(Terminal.C);
        super.beforeDataRequest(userInfos);

        JSONObject body = new JSONObject();
        body.put("id",activityId);
        body.put("memberId",memberId);

        dataApi.doRequest(RequestType.JSON, dataparams, body.toJSONString(), dataheadrs).assetsSuccess(true);
        return Integer.parseInt(dataApi.getBodyInJSON().getString("result"));
    }
    /**
     * 小程序查看我的奖品
     * @param activityId
     * @param memberId
     * @return
     */
    public JSONObject getMyActPrizeByPage(String activityId,String memberId,DataUserInfo...userInfos) {
        dataApi.setApiModule(ApiModule.Lunar_LuckyDraw)
                .setApiName("API_getMyActPrizeByPage")
                .setTerminal(Terminal.C);
        super.beforeDataRequest(userInfos);

        JSONObject body = new JSONObject();
        body.put("current",0);
        body.put("size",20);
        body.put("activityType","LUCKY_DRAW");
        body.put("activityId",activityId);
        body.put("memberId",memberId);

        dataApi.doRequest(RequestType.JSON, dataparams, body.toJSONString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * 小程序我的活动
     * @param memberId
     * @return
     */
    public JSONObject getMyActivityByPage(String memberId,DataUserInfo...userInfos) {
        dataApi.setApiModule(ApiModule.Lunar_LuckyDraw)
                .setApiName("API_getMyActivityByPage")
                .setTerminal(Terminal.C);
        super.beforeDataRequest(userInfos);

        JSONObject body = new JSONObject();
        body.put("current",0);
        body.put("size",20);
        body.put("activityType","LUCKY_DRAW");
        body.put("memberId",memberId);

        dataApi.doRequest(RequestType.JSON, dataparams, body.toJSONString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * 查看小程序我的优惠券
     * @param memberId
     * @return
     */
    public int countMemberReceivedCoupon(String memberId,DataUserInfo...userInfos) {
        dataApi.setApiModule(ApiModule.Lunar_Coupon)
                .setApiName("API_countMemberReceivedCoupon")
                .setTerminal(Terminal.C);
        super.beforeDataRequest(userInfos);

        JSONObject body = new JSONObject();
        body.put("receiverId",memberId);
        body.put("status","AVAILABLE");

        dataApi.doRequest(RequestType.JSON, dataparams, body.toJSONString(), dataheadrs).assetsSuccess(true);
        return Integer.parseInt(dataApi.getBodyInJSON().getString("result"));
    }

    /**
     * 小程序幸运抽奖活动进行抽奖
     * @param activityId
     * @param memberId
     * @param userInfos
     * @return
     */
    public JSONObject luckyDrawLottery(String activityId,String memberId,DataUserInfo...userInfos) {
        dataApi.setApiModule(ApiModule.Lunar_LuckyDraw)
                .setApiName("API_luckyDrawLottery")
                .setTerminal(Terminal.C);
        super.beforeDataRequest(userInfos);

        JSONObject body = new JSONObject();
        body.put("id",activityId);
        body.put("memberId",memberId);

        dataApi.doRequest(RequestType.JSON, dataparams, body.toJSONString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * 兑换自定义奖品
     * @param sendRecordId
     * @param userInfos
     */
    public JSONObject exchangePrize(String sendRecordId,DataUserInfo...userInfos) {
        dataApi.setApiModule(ApiModule.Polar_LuckyDraw)
                .setApiName("API_exchangePrize")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfos);

        JSONObject body = new JSONObject();
        body.put("id",sendRecordId);
        body.put("manual",true);
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, body.toJSONString(), dataheadrs);
        return dataApi.getBodyInJSON();
    }

    /**
     * 核对中奖信息
     * @param sendRecordId
     * @param userInfos
     * @return
     */
    public JSONObject getRewardSendDetail(String sendRecordId,DataUserInfo...userInfos) {
        dataApi.setApiModule(ApiModule.Polar_LuckyDraw)
                .setApiName("API_getRewardSendDetail")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfos);

        JSONObject body = new JSONObject();
        body.put("id",sendRecordId);
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, body.toJSONString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }
}
