package com.xiaomai.utils;

import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.testng.annotations.Test;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

public class CommUtil {
    public static Date now = new Date();

    public static String getCurrentTime() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df.toString();
    }

    public static String getTimeStamp() {
        Long ct = System.currentTimeMillis();
        return ct.toString();
    }

    /**
     * 获取配置文件指出参数信息
     *
     * @return 返回一个文件对象
     */
    public static Properties getconfig() {
        Properties prop = null;

        try {
//          数据流的形式读取配置文件
            prop = new Properties();
            FileInputStream fis = new FileInputStream(System.getProperty("user.dir") +
                    "/src/main/resources/config.properties");
            prop.load(fis);
        } catch (Exception e) {
            e.printStackTrace();
        }

        return prop;

    }

    //把JavaBean转化为map
    public static Map<String, String> bean2map(Object bean) {
        Map<String, String> map = new HashMap<>();
        //获取JavaBean的描述器
        try {
            BeanInfo b = Introspector.getBeanInfo(bean.getClass(), Object.class);
            //获取属性描述器
            PropertyDescriptor[] pds = b.getPropertyDescriptors();
            for (PropertyDescriptor pd : pds) {
                String propertyName = pd.getName();
                Method m = pd.getReadMethod();
                Object properValue = m.invoke(bean);
                if (null != properValue) {
                    map.put(propertyName, properValue.toString());
                }
            }
        } catch (Exception e) {
            return null;
        } finally {
            return map;
        }

    }

    /**
     * 在当前时间上增加days天，days – 可以为负
     *
     * @param days
     * @return
     */
    public static Date addDay(int days) {
        return new LocalDate().plusDays(days).toDate();
    }

    public static String getFormatTimeStr(Date date, String format) {
        assert date != null;
        try {
            return new SimpleDateFormat(format).format(date);
        } catch (Exception ignored) {
            return "";
        }
    }

    /**
     * 获取日期的时间戳格式
     *
     * @param time    制定日期时间,根据pattern格式传值
     * @param pattern 时间格式 比如1>yyyy-MM-dd HH:mm:ss 2>yyyy-MM-dd 3>yyyy-MM-dd HH:mm
     * @return
     */
    public static String getStringTimestamp(String time, String pattern) {
        Date date = null;
        try {
            date = getFormattedDate(time, pattern);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return date.getTime() + "";

    }

    /**
     * 将指定格式的日期时间字符串，转换为Date
     * 若 指定格式 与 日期时间字符串 不一致时，会抛出转换异常
     *
     * @param dateStr 日期时间字符串
     * @param format  指定格式
     * @return
     * @throws ParseException
     */
    public static Date getFormattedDate(String dateStr, String format) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.parse(dateStr);
    }


    /**
     * 获取当前时间+n天的日期时间戳，一般是开始日期的时间戳 00：00：00
     *
     * @return
     */
    public static String oneKeyGetAddDay(int day) {
        Date getAddDayData = addDay(day);//获取本周的第一天
        String getAddDayDataString = getFormatTimeStr(getAddDayData, "yyyy-MM-dd HH:mm:ss");//时间格式转化为string
        return getStringTimestamp(getAddDayDataString, "yyyy-MM-dd HH:mm:ss");
    }


    public static Date getStartOfDateWeek(Date date) {
        return new DateTime(date).withDayOfWeek(1).withTimeAtStartOfDay().toDate();
    }

    /**
     * 获取本周第一天
     *
     * @return
     */
    public static String oneKeyGetWeekStartDay() {
        Date getWeekStartDayData = getStartOfDateWeek(now);//获取本周的第一天
        String getWeekStartDay = getFormatTimeStr(getWeekStartDayData, "yyyy-MM-dd HH:mm:ss");//时间格式转化为string
        return getStringTimestamp(getWeekStartDay, "yyyy-MM-dd HH:mm:ss");
    }

    public static Date getEndOfDateWeek(Date date) {
        return new DateTime(date).withDayOfWeek(7).withTime(23, 59, 59, 0).toDate();
    }

    /**
     * 获取本周最后一天
     *
     * @return
     */
    public static String oneKeyGetWeekEndDay() {
        Date getWeekEndDayData = getEndOfDateWeek(now);//获取本周的最后一天
        String getWeekEndDay = getFormatTimeStr(getWeekEndDayData, "yyyy-MM-dd HH:mm:ss");//时间格式转化为string
        return getStringTimestamp(getWeekEndDay, "yyyy-MM-dd HH:mm:ss");
    }

    public static Date getEndOfDay(Date date) {
        assert date != null;
        return new DateTime(date).withTime(23, 59, 59, 999).toDate();
    }

    /**
     * 设定时间+N天
     *
     * @param date 设置的时间  Date now=new Date();
     * @param n    天
     * @return
     */
    public static Date addNDays(Date date, int n) {
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        now.add(Calendar.DAY_OF_MONTH, n);
        return now.getTime();

    }

    /**
     * 当前时间+n天结束日期时间戳 23：59：59
     * @param n
     * @return
     */
    public static String getNDayEndTimeTamp(int n){
        Date now = new Date();
        Date totalDate = addNDays(now, n);
        String getNDayEndTime = getFormatTimeStr(getEndOfDay(totalDate), "yyyy-MM-dd HH:mm:ss");//时间格式转化为string
        return getStringTimestamp(getNDayEndTime, "yyyy-MM-dd HH:mm:ss");
    }


    //@Test
    public void test() {
        //当天时间戳格式：2024-6-12 00：00：00点
        System.out.println("当前时间时间戳" + oneKeyGetAddDay(0));
        System.out.println("****" +getNDayEndTimeTamp(0));



    }


}
