package com.xiaomai.cases.polar.finance.order;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;

public class OrderTools extends XMBaseTest {

    /**
     * @param
     * @description:获取会员详情-订单管理列表
     * @author: yangfangfang
     **/
    public JSONObject testPageMemberVoucher(String current,String size,String supplierId,String receiverId,String brandId,String studioId,String operatorId,DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_pageMemberVoucher")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("current","");
        jsonObject.put("size","");
        jsonObject.put("supplierId","");
        jsonObject.put("receiverId","");
        jsonObject.put("brandId","");
        jsonObject.put("studioId","");
        jsonObject.put("operatorId","");

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:获取会员详情-订单管理金额统计
     * @author: yangfangfang
     **/
    public JSONObject testSumMemberVoucherAmount(String current,String size,String supplierId,String receiverId,String brandId,String studioId,String operatorId,DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_sumMemberVoucherAmount")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("current","");
        jsonObject.put("size","");
        jsonObject.put("supplierId","");
        jsonObject.put("receiverId","");
        jsonObject.put("brandId","");
        jsonObject.put("studioId","");
        jsonObject.put("operatorId","");

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:获取会员详情-订单明细列表
     * @author: yangfangfang
     **/
    public JSONObject testPageMemberVoucherItem(String current,String size,String supplierId,String receiverId,String brandId,String studioId,String operatorId,DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_pageMemberVoucherItem")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("current","");
        jsonObject.put("size","");
        jsonObject.put("supplierId","");
        jsonObject.put("receiverId","");
        jsonObject.put("brandId","");
        jsonObject.put("studioId","");
        jsonObject.put("operatorId","");

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }


    /**
     * @param
     * @description:获取订单管理-订单管理列表
     * @author: yangfangfang
     **/
    public JSONObject testPageVoucher(String current,String size,String supplierId,String receiverId,String brandId,String studioId,String operatorId,DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_pageVoucher")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("current","");
        jsonObject.put("size","");
        jsonObject.put("supplierId","");
        jsonObject.put("receiverId","");
        jsonObject.put("brandId","");
        jsonObject.put("studioId","");
        jsonObject.put("operatorId","");

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:获取订单管理-订单管理金额统计
     * @author: yangfangfang
     **/
    public JSONObject testSumVoucherAmount(String current,String size,String supplierId,String receiverId,String brandId,String studioId,String operatorId,DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_sumVoucherAmount")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("current", "");
        jsonObject.put("size", "");
        jsonObject.put("supplierId", "");
        jsonObject.put("receiverId", "");
        jsonObject.put("brandId", "");
        jsonObject.put("studioId", "");
        jsonObject.put("operatorId", "");

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:获取订单管理-订单明细列表
     * @author: yangfangfang
     **/
    public JSONObject testPageVoucherItem(String current,String size,String supplierId,String receiverId,String brandId,String studioId,String operatorId,DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_pageVoucherItem")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("current","");
        jsonObject.put("size","");
        jsonObject.put("supplierId","");
        jsonObject.put("receiverId","");
        jsonObject.put("brandId","");
        jsonObject.put("studioId","");
        jsonObject.put("operatorId","");

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:获取订单管理-订单明细金额统计
     * @author: yangfangfang
     **/
    public JSONObject testSumVoucherItemAmount(String current,String size,String supplierId,String receiverId,String brandId,String studioId,String operatorId,DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_sumVoucherItemAmount")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("current","");
        jsonObject.put("size","");
        jsonObject.put("supplierId","");
        jsonObject.put("receiverId","");
        jsonObject.put("brandId","");
        jsonObject.put("studioId","");
        jsonObject.put("operatorId","");

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }


}
