package com.xiaomai.cases.polar.studioConfig;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.springframework.stereotype.Component;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.studioConfig
 * @Author: xuyamei
 * @CreateTime: 2024-03-01  10:52
 * @Description: 通用配置
 * @Version: 1.0
 */
@Component("configTools")
public class ConfigTools extends XMBaseTest {

    /**
     * @description:操作日志
     * @author: xuyamei
     * @date:  2024/3/1 11:00
     * @param body 请求参数
     * @param dataUserInfos
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONObject getOpauditPage(String body, DataUserInfo...dataUserInfos){
        dataApi.setApiModule(ApiModule.Polar_Config)
                .setApiName("API_opaudit_getPage")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        dataApi.doRequest(RequestType.JSON,dataparams,body,dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }
}
