package com.xiaomai.cases.polar.clue;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author zxy
 * @Description
 * @Date 2024/6/28 16:28
 */
public class TestFindByObjectId extends XMBaseTest {
    @BeforeMethod
    public void beforeTest(){

        xmAppApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_findByObjectId")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("zyx")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "线索来源")
    public void testFindByObjectId(){
        List categories = new ArrayList();
        categories.add("RESOURCE");

        JSONObject object = new JSONObject();
        object.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        object.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        object.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
        object.put("categories",categories);
        object.put("objectId","1760544120783314946");

        xmAppApi.doRequest(RequestType.JSON,params,object.toString(),headers).assetsSuccess(true);
    }
}
