package com.xiaomai.cases.polar.eleContract;

import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.eleContract
 * @Author: xuyamei
 * @CreateTime: 2024-08-05  11:44
 * @Description: 获取企业签章
 * @Version: 1.0
 */
public class TestGetCompanySignature extends BaseTestImpl {

        @BeforeMethod
        @Override
        public void beforeTest(){
            setTestInfo(ApiModule.Polar_EleContract,"API_getCompanySignature", LoginAccount.DZHT_PROD, Terminal.B,"xym");
            super.beforeTest();
        }

        @Test
        public void testGetCompanySignature(){
            String body = "{\"tenantId\":\""+xmAppApi.getLoginInfo().getStudioId()+"\"}";
            xmAppApi.doRequest(RequestType.JSON,params,body,headers).assetsSuccess(true);
            Assert.assertEquals(xmAppApi.getBodyInJSON().getJSONObject("result").getString("signatureUrl"),"https://fit-resource-pub.xiaomai5.com/fitness/1796482011391729666/BRAND/eleContract/1815396391027736577/20240722224002/signature.png","获取企业签章失败");
        }

}
