package com.xiaomai.cases.polar.brandMerchant;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.studioConfig.MerchantTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;

/**
 * @Author: xyy
 * @CreateTime: 2024-04-23  11:48
 * @Description: 获取修改记录详情
 * @Version: 1.0
 */
public class TestGetApply extends XMBaseTest {

    @Resource(name = "merchantTools")
    MerchantTools merchantTools;

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Merchant)
                .setApiName("API_getApply")
                .setLoginUser(LoginAccount.XYY_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("xyy")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "获取修改记录详情")
    public void testPageApply() {

        JSONObject body = merchantTools.getApplyPage();
        int total = Integer.parseInt(body.getJSONObject("result").getString("total"));
        String applyId = body.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");


        JSONObject object = new JSONObject();
        object.put("id", applyId);
        object.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        object.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        object.put("operatorId", xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON, params, object.toJSONString(), headers);
        JSONObject response = xmAppApi.getBodyInJSON();

        if (total != 0) {
            Assert.assertEquals(XMJSONPath.readPath(response, "$.message"), "操作成功!");
            Assert.assertEquals(XMJSONPath.readPath(response, "$.result.applyType"), "BIND");
            Assert.assertEquals(XMJSONPath.readPath(response, "$.result.openState"), "SUCCESS");
        } else {
            Assert.assertEquals(XMJSONPath.readPath(response, "$.message"), "数据不存在");
        }
    }
}
