package com.xiaomai.cases.polar.invitationGifts;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
@Component("InvitationGiftsTools")
public class InvitationGiftsTools extends BaseTestImpl {
    /**
     * @description:创建邀请有礼
     * @param allowJoinedUser 被邀请人参与条件
     * @param publish 活动是否发布
     */
    public JSONObject createInvitationActivity(String activityName,String allowJoinedUser,long endTime,long startTime,Boolean publish,String prizeId1,String prizeId2,String prizeId3,String prizeId4,String prizeType1,String prizeType2,String prizeType3,String prizeType4, DataUserInfo...userInfo){
        dataApi.setApiModule(ApiModule.Polar_Invitation)
                .setApiName("API_createInvitationActivity")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfo);


        JSONObject body1 = new JSONObject();
        body1.put("prizeId",prizeId1);//优惠券或体验卡ID
        body1.put("prizeType",prizeType1);//优惠券COUPON 体验卡EXPERIENCE_CARD
        body1.put("rewardType","ACQUISITION");//拉新奖励

        JSONObject body2 = new JSONObject();
        body2.put("prizeId",prizeId2);//优惠券或体验卡ID
        body2.put("prizeType",prizeType2);//优惠券COUPON 体验卡EXPERIENCE_CARD
        body2.put("rewardType","TO_STORE");//到店奖励

        JSONObject body3 = new JSONObject();
        body3.put("prizeId",prizeId3);//优惠券或体验卡ID
        body3.put("prizeType",prizeType3);//优惠券COUPON 体验卡EXPERIENCE_CARD
        body3.put("rewardType","DEAL");//成交奖励

        JSONObject body4 = new JSONObject();
        body4.put("prizeId",prizeId4);//优惠券或体验卡ID
        body4.put("prizeType",prizeType4);//优惠券COUPON 体验卡EXPERIENCE_CARD
        body4.put("rewardType","MANUAL_COLLECTION");//被邀请人奖品

        List<JSONObject> rewardRules = new ArrayList<>();
        rewardRules.add(body1);
        rewardRules.add(body2);
        rewardRules.add(body3);
        rewardRules.add(body4);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("activityName",activityName);
        jsonObject.put("activityRule","自动化-活动规则");//活动规则
        jsonObject.put("allowJoinedUser",allowJoinedUser);//UNREGISTERED 未注册；NO_CONSUME未消费
        jsonObject.put("bgColor","#FFEBE8");
        jsonObject.put("invitedDesc","自动化-邀你享新人专属福利");//邀请链接文案
        jsonObject.put("endTime",endTime);//活动结束时间
        jsonObject.put("startTime",startTime);//活动开始时间
        jsonObject.put("invitedPicId","0");
        jsonObject.put("inviteePagePicId","0");
        jsonObject.put("posterBgPicId","0");
        jsonObject.put("promoterPagePicId","0");
        jsonObject.put("publish",publish);//true发布；false未发布
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());
        jsonObject.put("rewardRules",rewardRules);//奖品规则


        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;

    }


    /**
     * @description:编辑邀请有礼 进行中仅能编辑活动名称、活动规则、高级设置  未发布&未开始都可以编辑
     * @param allowJoinedUser 被邀请人参与条件
     * @param publish 活动是否发布
     * @param activityId 活动id
     */
    public JSONObject invitationActivityEdit(String allowJoinedUser,String activityId,long endTime,long startTime,Boolean publish,String prizeId1,String prizeId2,String prizeId3,String prizeId4,String prizeType1,String prizeType2,String prizeType3,String prizeType4, DataUserInfo...userInfo){
        dataApi.setApiModule(ApiModule.Polar_Invitation)
                .setApiName("API_invitationActivityEdit")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfo);


        JSONObject body1 = new JSONObject();
        body1.put("prizeId",prizeId1);//优惠券或体验卡ID
        body1.put("prizeType",prizeType1);//优惠券COUPON 体验卡EXPERIENCE_CARD
        body1.put("rewardType","ACQUISITION");//拉新奖励

        JSONObject body2 = new JSONObject();
        body2.put("prizeId",prizeId2);//优惠券或体验卡ID
        body2.put("prizeType",prizeType2);//优惠券COUPON 体验卡EXPERIENCE_CARD
        body2.put("rewardType","TO_STORE");//到店奖励

        JSONObject body3 = new JSONObject();
        body3.put("prizeId",prizeId3);//优惠券或体验卡ID
        body3.put("prizeType",prizeType3);//优惠券COUPON 体验卡EXPERIENCE_CARD
        body3.put("rewardType","DEAL");//成交奖励

        JSONObject body4 = new JSONObject();
        body4.put("prizeId",prizeId4);//优惠券或体验卡ID
        body4.put("prizeType",prizeType4);//优惠券COUPON 体验卡EXPERIENCE_CARD
        body4.put("rewardType","MANUAL_COLLECTION");//被邀请人奖品

        List<JSONObject> rewardRules = new ArrayList<>();
        rewardRules.add(body1);
        rewardRules.add(body2);
        rewardRules.add(body3);
        rewardRules.add(body4);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("activityName","自动化-编辑邀请有礼");
        jsonObject.put("activityRule","自动化-编辑活动规则");//活动规则
        jsonObject.put("allowJoinedUser",allowJoinedUser);//UNREGISTERED 未注册；NO_CONSUME未消费
        jsonObject.put("bgColor","#FFEBE8");
        jsonObject.put("invitedDesc","自动化-编辑邀你享新人专属福利");//邀请链接文案
        jsonObject.put("endTime",endTime);//活动结束时间
        jsonObject.put("startTime",startTime);//活动开始时间
        jsonObject.put("invitedPicId","0");
        jsonObject.put("inviteePagePicId","0");
        jsonObject.put("posterBgPicId","0");
        jsonObject.put("promoterPagePicId","0");
        jsonObject.put("publish",publish);//true发布；false未发布
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("activityId",activityId);
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());
        jsonObject.put("rewardRules",rewardRules);//奖品规则


        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;

    }

    /**
     * @param
     * @description:发布邀请有礼活动
     * @author: yangjian
     * @param activityId 活动ID

     **/
    public JSONObject invitationActivityPublish(String activityId, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Invitation)
                .setApiName("API_invitationActivityPublish")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("activityId", activityId);//活动ID
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:删除邀请有礼活动
     * @author: yangjian
     * @param activityId 活动ID

     **/
    public JSONObject invitationActivityDelete(String activityId, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Invitation)
                .setApiName("API_invitationActivityDelete")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("activityId", activityId);//活动ID
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:失效邀请有礼活动
     * @author: yangjian
     * @param activityId 活动ID

     **/
    public JSONObject invitationActivityInvalid(String activityId, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Invitation)
                .setApiName("API_invitationActivityInvalid")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("activityId", activityId);//活动ID
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }


    /**
     * @param
     * @description:邀请有礼列表
     * @author: yangjian


     **/
    public JSONObject invitationActivity_getStudioPage( DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Invitation)
                .setApiName("API_invitationActivity_getStudioPage")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        //List<String> states = new ArrayList<>();
        //states.add(state);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("current", 0);
        jsonObject.put("size", 10);
        //jsonObject.put("states", states);//活动状态
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:邀请有礼列表搜索活动
     * @author: yangjian
     * @param activityNameLike 活动名称

     **/
    public JSONObject invitationActivity_getStudioPage1(String activityNameLike, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Invitation)
                .setApiName("API_invitationActivity_getStudioPage")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("current", 0);
        jsonObject.put("size", 10);
        jsonObject.put("activityNameLike", activityNameLike);//活动名称
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:邀请有礼活动详情
     * @author: yangjian
     * @param activityId 活动ID

     **/
    public JSONObject getInvitationActivityDetail(String activityId, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Invitation)
                .setApiName("API_getInvitationActivityDetail")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();

        jsonObject.put("activityId", activityId);//活动名称
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:邀请有礼-活动数据-数据概括
     * @author: yangjian
     * @param activityId 活动ID

     **/
    public JSONObject InvitationGetStudioStatisticsData(String activityId,String beginDate,String endDate, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Invitation)
                .setApiName("API_InvitationGetStudioStatisticsData")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();

        jsonObject.put("activityId", activityId);//活动ID
        jsonObject.put("beginDate", beginDate);
        jsonObject.put("endDate", endDate);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:邀请有礼-活动数据-推广名单
     * @author: yangjian
     * @param activityId 活动ID

     **/
    public JSONObject getPromoteRecordPage(String activityId,String beginDate,String endDate,String promoterId, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Invitation)
                .setApiName("API_getPromoteRecordPage")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();

        jsonObject.put("activityId", activityId);//活动ID
        jsonObject.put("size", 20);
        jsonObject.put("current", 0);
        jsonObject.put("beginDate", beginDate);
        jsonObject.put("endDate", endDate);
        jsonObject.put("promoterId", promoterId);//会员ID
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:邀请有礼-活动数据-受邀名单
     * @author: yangjian
     * @param activityId 活动ID

     **/
    public JSONObject getJoinedRecordPage(String activityId, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Invitation)
                .setApiName("API_getJoinedRecordPage")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();

        jsonObject.put("activityId", activityId);//活动ID
        jsonObject.put("size", 20);
        jsonObject.put("beginDate", null);
        jsonObject.put("endDate", null);
        jsonObject.put("newRegistration", null);
        jsonObject.put("achievedReward", null);
        jsonObject.put("inviteeId", null);
        jsonObject.put("sortType", null);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:邀请有礼-活动数据-发放奖品
     * @author: yangjian
     * @param activityId 活动ID

     **/
    public JSONObject getRewardSendRecordPage(String activityId, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Invitation)
                .setApiName("API_getRewardSendRecordPage")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();

        jsonObject.put("activityId", activityId);//活动ID
        jsonObject.put("size", 20);
        jsonObject.put("activityType", "INVITATION");
        jsonObject.put("current", 0);
        jsonObject.put("beginDate", null);
        jsonObject.put("endDate", null);
        jsonObject.put("sendState", null);
        jsonObject.put("prizeType", null);
        jsonObject.put("receivedMemberId", null);
        jsonObject.put("achievedRewardTypes", null);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }




}
