package com.xiaomai.cases.lunar.reserve;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.polar.setting.rules.RuleTools;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.util.Random;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.lunar.reserve
 * @Author: xuyamei
 * @CreateTime: 2024-06-27  11:03
 * @Description: 编辑约课规则小程序查询规则
 * @Version: 1.0
 */
public class TestGetGroupBookingRules extends BaseTestImpl {
    @Resource(name = "reserveCTools")
    ReserveCTools reserveCTools;

    @Resource(name = "ruleTools")
    RuleTools ruleTools;

    @BeforeClass
    public void beforeTest() {
        setTestInfo(ApiModule.Lunar_Reserve, "API_getGroupBookingRules", LoginAccount.XYM_MINIAPPC, Terminal.minApp, "xym");
        super.beforeTest();
    }

    @DataProvider
    public Object[][] dataProvider() {
        Random random = new Random();
        int bookingSeatCount = random.nextInt(10) + 1; // 席位
        return new Object[][]{
                {true, bookingSeatCount, true, true, random.nextInt(30) + 10, true, random.nextInt(1000) + 10, random.nextInt(5) + 1, true, random.nextInt(1000) + 10, "minutes", true, random.nextInt(1000) + 10, "minutes"},
                {false, bookingSeatCount, false, false, random.nextInt(30) + 10, false, random.nextInt(1000) + 10, random.nextInt(5) + 1, false, random.nextInt(1000) + 10, "minutes", false, random.nextInt(1000) + 10, "minutes"},
        };
    }

    @Test(dataProvider = "dataProvider")
    public void testGetGroupBookingRules(boolean allowQueuing, int bookingSeatCount, boolean xcxAutoSignIn, boolean scanSignIn, int signInBeforeMinutes,
                                         boolean bookingStartRuleRequest, int startComingDayMinuteOffset, int startComingDays, boolean bookingEndRuleRequest,
                                         int endBeforeMinutes, String endBeforeUnit, boolean cancelBookingRuleRequest, int cancelBookingBeforeMinutes, String cancelBookingBeforeUnit) {
        DataUserInfo dataUserInfo = new DataUserInfo();
        dataUserInfo.setTerminal(Terminal.B);
        dataUserInfo.setLoginUser(LoginAccount.GYM_PROD);

        JSONObject getRules = ruleTools.getGroupBookingRules(); // 获取场馆团课预约规则
        String id = getRules.getString("id"); // 获取规则id
        ruleTools.saveGroupBookingRules(id, allowQueuing, bookingSeatCount, xcxAutoSignIn, scanSignIn, signInBeforeMinutes, bookingStartRuleRequest, startComingDayMinuteOffset, startComingDays, bookingEndRuleRequest, endBeforeMinutes, endBeforeUnit, cancelBookingRuleRequest, cancelBookingBeforeMinutes, cancelBookingBeforeUnit,dataUserInfo);

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        getRules = reserveCTools.getGroupBookingRules();
        for (int i = 0; i < 14; i++){
            Assert.assertEquals(getRules.getBooleanValue("allowQueuing"),allowQueuing);
            Assert.assertEquals(getRules.getIntValue("bookingSeatCount"),bookingSeatCount);
            Assert.assertEquals(getRules.getBooleanValue("xcxAutoSignIn"),xcxAutoSignIn);
            Assert.assertEquals(getRules.getBooleanValue("scanSignIn"),scanSignIn);
            Assert.assertEquals(getRules.getIntValue("signInBeforeMinutes"),signInBeforeMinutes);
            if (bookingStartRuleRequest){  // 预约时间限制
                Assert.assertEquals(getRules.getJSONObject("groupBookingStartRuleVO").getIntValue("bookingStartComingDays"),startComingDays);
                Assert.assertEquals(getRules.getJSONObject("groupBookingStartRuleVO").getIntValue("bookingStartComingDayMinuteOffset"),startComingDayMinuteOffset);

            }
            Assert.assertEquals(getRules.getJSONObject("groupBookingStartRuleVO").getBooleanValue("limit"),bookingStartRuleRequest);


            if (bookingEndRuleRequest){  // 截止预约时间限制
                Assert.assertEquals(getRules.getJSONObject("groupBookingEndRuleVO").getIntValue("bookingEndBeforeMinutes"),endBeforeMinutes);
                Assert.assertEquals(getRules.getJSONObject("groupBookingEndRuleVO").getString("bookingEndBeforeUnit"),endBeforeUnit);

            }
            Assert.assertEquals(getRules.getJSONObject("groupBookingEndRuleVO").getBooleanValue("limit"),bookingEndRuleRequest);


            if (cancelBookingRuleRequest){ // 取消预约限制
                Assert.assertEquals(getRules.getJSONObject("cancelGroupBookingRuleVO").getIntValue("cancelBookingBeforeMinutes"),cancelBookingBeforeMinutes);
                Assert.assertEquals(getRules.getJSONObject("cancelGroupBookingRuleVO").getString("cancelBookingBeforeUnit"),cancelBookingBeforeUnit);

            }
            Assert.assertEquals(getRules.getJSONObject("cancelGroupBookingRuleVO").getBooleanValue("limit"),cancelBookingRuleRequest);

        }
    }
}